/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport.grpc.proto.request.search;

import java.io.IOException;
import java.util.ArrayList;
import org.opensearch.index.query.InnerHitBuilder;
import org.opensearch.protobufs.FieldCollapse;
import org.opensearch.protobufs.InnerHits;
import org.opensearch.search.collapse.CollapseBuilder;
import org.opensearch.transport.grpc.proto.request.search.InnerHitsBuilderProtoUtils;

public class CollapseBuilderProtoUtils {
    private CollapseBuilderProtoUtils() {
    }

    protected static CollapseBuilder fromProto(FieldCollapse collapseProto) throws IOException {
        CollapseBuilder collapseBuilder = new CollapseBuilder(collapseProto.getField());
        if (collapseProto.hasMaxConcurrentGroupSearches()) {
            collapseBuilder.setMaxConcurrentGroupRequests(collapseProto.getMaxConcurrentGroupSearches());
        }
        if (collapseProto.getInnerHitsCount() > 0) {
            ArrayList<InnerHitBuilder> innerHitBuilders = new ArrayList<InnerHitBuilder>();
            for (InnerHits innerHits : collapseProto.getInnerHitsList()) {
                innerHitBuilders.add(InnerHitsBuilderProtoUtils.fromProto(innerHits));
            }
            collapseBuilder.setInnerHits(innerHitBuilders);
        }
        return collapseBuilder;
    }
}

