/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.deployer.api;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.craftercms.deployer.api.ChangeSet;
import org.craftercms.deployer.api.Deployment;
import org.craftercms.deployer.api.ProcessorExecution;
import org.craftercms.deployer.api.Target;

/*
 * Exception performing whole class analysis ignored.
 */
@JsonPropertyOrder(value={"mode", "status", "running", "duration", "start", "end", "created_files", "updated_files", "deleted_files"})
public class Deployment {
    protected Target target;
    protected volatile ZonedDateTime start;
    protected volatile ZonedDateTime end;
    protected volatile Status status;
    protected volatile ChangeSet changeSet = new ChangeSet();
    protected List<ProcessorExecution> processorExecutions;
    protected Map<String, Object> params;
    protected Lock lock;
    protected Mode mode = Mode.PUBLISH;

    public Deployment(Target target) {
        this.target = target;
        this.processorExecutions = new ArrayList();
        this.params = new ConcurrentHashMap();
        this.lock = new ReentrantLock();
    }

    public Deployment(Target target, Map<String, Object> params) {
        this.target = target;
        this.processorExecutions = new ArrayList();
        this.params = new ConcurrentHashMap<String, Object>(params);
        this.lock = new ReentrantLock();
        if (params.containsKey("deployment_mode")) {
            this.mode = Mode.valueOf((String)((String)params.get("deployment_mode")));
        }
    }

    public Target getTarget() {
        return this.target;
    }

    @JsonProperty(value="start")
    public ZonedDateTime getStart() {
        return this.start;
    }

    @JsonProperty(value="end")
    public ZonedDateTime getEnd() {
        return this.end;
    }

    public boolean isRunning() {
        return this.start != null && this.end == null;
    }

    @JsonProperty(value="duration")
    public Long getDuration() {
        if (this.start != null && this.end != null) {
            return this.start.until(this.end, ChronoUnit.MILLIS);
        }
        return null;
    }

    @JsonProperty(value="status")
    public Status getStatus() {
        return this.status;
    }

    @JsonProperty(value="mode")
    public Mode getMode() {
        return this.mode;
    }

    public ChangeSet getChangeSet() {
        return this.changeSet;
    }

    public void setChangeSet(ChangeSet changeSet) {
        this.changeSet = changeSet;
    }

    @JsonIgnore
    public boolean isChangeSetEmpty() {
        return this.changeSet == null || this.changeSet.isEmpty();
    }

    public void start() {
        if (!this.isRunning()) {
            this.end = null;
            this.start = ZonedDateTime.now();
        }
    }

    public void end(Status status) {
        if (this.isRunning()) {
            this.end = ZonedDateTime.now();
            this.status = status;
        }
    }

    public List<ProcessorExecution> getProcessorExecutions() {
        this.lock.lock();
        try {
            ArrayList<ProcessorExecution> arrayList = new ArrayList<ProcessorExecution>(this.processorExecutions);
            return arrayList;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void addProcessorExecution(ProcessorExecution status) {
        this.lock.lock();
        try {
            this.processorExecutions.add(status);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void addParam(String name, Object value) {
        this.params.put(name, value);
    }

    public Object getParam(String name) {
        return this.params.get(name);
    }

    public void removeParam(String name) {
        this.params.remove(name);
    }

    public String toString() {
        return "Deployment{targetId='" + this.target.getId() + "', start=" + String.valueOf(this.start) + ", end=" + String.valueOf(this.end) + ", running=" + this.isRunning() + ", duration=" + this.getDuration() + ", status=" + String.valueOf(this.status) + ", mode=" + String.valueOf(this.mode) + ", changeSet=" + String.valueOf(this.changeSet) + ", processorExecutions=" + String.valueOf(this.processorExecutions) + ", params=" + String.valueOf(this.params) + "}";
    }
}

