/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.deployer.impl;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.deployer.api.exceptions.DeployerException;
import org.craftercms.deployer.impl.ProcessedCommitsStore;
import org.eclipse.jgit.lib.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessedCommitsStoreImpl
implements ProcessedCommitsStore {
    private static final Logger logger = LoggerFactory.getLogger(ProcessedCommitsStoreImpl.class);
    protected File storeFolder;

    public void setStoreFolder(File storeFolder) {
        this.storeFolder = storeFolder;
    }

    public ObjectId load(String targetId) throws DeployerException {
        File commitFile = this.getCommitFile(targetId);
        try {
            if (commitFile.exists()) {
                String commitId = FileUtils.readFileToString((File)commitFile, (String)"UTF-8").trim();
                if (StringUtils.isNotEmpty((CharSequence)commitId)) {
                    logger.debug("Found previous processed commit ID for target '{}': {}", (Object)targetId, (Object)commitId);
                    return ObjectId.fromString((String)commitId);
                }
                logger.warn("Processed commit file {} is empty, will be deleted", (Object)commitFile);
                FileUtils.deleteQuietly((File)commitFile);
                return null;
            }
            return null;
        }
        catch (IOException e) {
            throw new DeployerException("Error retrieving previous processed commit ID from " + String.valueOf(commitFile), (Throwable)e);
        }
    }

    public void store(String targetId, ObjectId commitId) throws DeployerException {
        File commitFile = this.getCommitFile(targetId);
        try {
            logger.debug("Storing processed commit ID {} for target '{}'", (Object)commitId.name(), (Object)targetId);
            FileUtils.write((File)commitFile, (CharSequence)commitId.name(), (String)"UTF-8", (boolean)false);
        }
        catch (IOException e) {
            throw new DeployerException("Error saving processed commit ID to " + String.valueOf(commitFile), (Throwable)e);
        }
    }

    public void delete(String targetId) throws DeployerException {
        File commitFile = this.getCommitFile(targetId);
        if (commitFile.exists()) {
            logger.debug("Deleting processed commit from store for target '{}'", (Object)targetId);
            FileUtils.deleteQuietly((File)commitFile);
        }
    }

    protected File getCommitFile(String targetId) {
        return new File(this.storeFolder, targetId + ".commit");
    }
}

