/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.deployer.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.craftercms.commons.config.ConfigUtils;
import org.craftercms.commons.config.ConfigurationException;
import org.craftercms.deployer.api.exceptions.DeployerException;
import org.craftercms.deployer.api.lifecycle.TargetLifecycleHook;
import org.craftercms.deployer.impl.TargetLifecycleHooksResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component(value="targetLifecycleHooksResolver")
public class TargetLifecycleHooksResolverImpl
implements TargetLifecycleHooksResolver {
    private static final Logger logger = LoggerFactory.getLogger(TargetLifecycleHooksResolverImpl.class);

    public List<TargetLifecycleHook> getHooks(HierarchicalConfiguration<ImmutableNode> configuration, ApplicationContext applicationContext, String lifecycleHooksPropertyName) throws ConfigurationException, DeployerException {
        List hookConfigs = ConfigUtils.getConfigurationsAt(configuration, (String)lifecycleHooksPropertyName);
        ArrayList<TargetLifecycleHook> hooks = new ArrayList<TargetLifecycleHook>();
        if (CollectionUtils.isNotEmpty((Collection)hookConfigs)) {
            for (HierarchicalConfiguration hookConfig : hookConfigs) {
                String hookName = ConfigUtils.getRequiredStringProperty((Configuration)hookConfig, (String)"hookName");
                logger.debug("Initializing target lifecycle hook '{}'", (Object)hookName);
                try {
                    TargetLifecycleHook hook = (TargetLifecycleHook)applicationContext.getBean(hookName, TargetLifecycleHook.class);
                    hook.init((Configuration)hookConfig);
                    hooks.add(hook);
                }
                catch (NoSuchBeanDefinitionException e) {
                    throw new DeployerException("No target lifecycle hook bean found with name '" + hookName + "'", (Throwable)e);
                }
                catch (Exception e) {
                    throw new DeployerException("Failed to initialize target lifecycle hook '" + hookName + "'", (Throwable)e);
                }
            }
        }
        return hooks;
    }
}

