/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.deployer.impl.lifecycle;

import java.beans.ConstructorProperties;
import org.apache.commons.configuration2.Configuration;
import org.craftercms.commons.config.ConfigurationException;
import org.craftercms.deployer.api.Target;
import org.craftercms.deployer.api.exceptions.DeployerException;
import org.craftercms.deployer.impl.ProcessedCommitsStore;
import org.craftercms.deployer.impl.TargetImpl;
import org.craftercms.deployer.impl.lifecycle.AbstractLifecycleHook;
import org.eclipse.jgit.lib.ObjectId;

public class DuplicateProcessedCommitsHook
extends AbstractLifecycleHook {
    private final String siteName;
    private final String sourceSiteName;
    private final String env;
    private final ProcessedCommitsStore processedCommitsStore;

    @ConstructorProperties(value={"siteName", "sourceSiteName", "env", "processedCommitsStore"})
    public DuplicateProcessedCommitsHook(String siteName, String sourceSiteName, String env, ProcessedCommitsStore processedCommitsStore) {
        this.siteName = siteName;
        this.sourceSiteName = sourceSiteName;
        this.env = env;
        this.processedCommitsStore = processedCommitsStore;
    }

    protected void doInit(Configuration config) throws ConfigurationException, DeployerException {
    }

    protected void doExecute(Target target) throws DeployerException {
        this.logger.info("Starting processed-commits file duplicate from site '{}' to site '{}'", (Object)this.sourceSiteName, (Object)this.siteName);
        String srcTargetId = TargetImpl.getId((String)this.env, (String)this.sourceSiteName);
        String newTargetId = TargetImpl.getId((String)this.env, (String)this.siteName);
        ObjectId processedCommit = this.processedCommitsStore.load(srcTargetId);
        if (processedCommit != null) {
            this.processedCommitsStore.store(newTargetId, processedCommit);
            this.logger.info("Completed processed-commits file duplicate from site '{}' to site '{}'", (Object)this.sourceSiteName, (Object)this.siteName);
        } else {
            this.logger.info("No processed-commits file found for site '{}' env '{}'", (Object)this.sourceSiteName, (Object)this.env);
        }
    }
}

