/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.deployer.impl.lifecycle.aws;

import java.beans.ConstructorProperties;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.commons.aws.AwsUtils;
import org.craftercms.commons.config.ConfigUtils;
import org.craftercms.commons.config.ConfigurationException;
import org.craftercms.commons.http.HttpUtils;
import org.craftercms.deployer.api.Target;
import org.craftercms.deployer.api.TargetService;
import org.craftercms.deployer.api.exceptions.DeployerException;
import org.craftercms.deployer.impl.ProcessedCommitsStore;
import org.craftercms.deployer.impl.lifecycle.AbstractLifecycleHook;
import org.craftercms.deployer.utils.aws.AwsS3ClientBuilderConfigurer;
import org.craftercms.deployer.utils.aws.AwsS3Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.S3AsyncClientBuilder;
import software.amazon.awssdk.services.s3.S3BaseClientBuilder;
import software.amazon.awssdk.services.s3.S3Uri;
import software.amazon.awssdk.services.s3.S3Utilities;

public class DuplicateS3LifecycleHook
extends AbstractLifecycleHook {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String GIT_ROOT = ".git" + File.separator;
    protected static final String CONFIG_KEY_IGNORE_BLOBS = "ignoreBlobs";
    protected static final String CONFIG_KEY_SOURCE_CONFIG = "sourceConfig";
    protected static final String CONFIG_KEY_LOCAL_REPO_URL = "localRepoPath";
    protected static final String CONFIG_KEY_URL = "url";
    protected static final String DELIMITER = "/";
    private final String siteName;
    private final String sourceSiteName;
    private final ProcessedCommitsStore processedCommitsStore;
    private final TargetService targetService;
    private final String blobExtension;
    private final ThreadPoolTaskExecutor threadPoolTaskExecutor;
    private boolean ignoreBlobs;
    private AwsS3ClientBuilderConfigurer builderConfigurer;
    private S3Uri s3Url;
    private S3Uri srcS3Url;
    private String srcLocalRepoPath;

    @ConstructorProperties(value={"siteName", "sourceSiteName", "processedCommitsStore", "targetService", "blobExtension", "threadPoolTaskExecutor"})
    public DuplicateS3LifecycleHook(String siteName, String sourceSiteName, ProcessedCommitsStore processedCommitsStore, TargetService targetService, String blobExtension, ThreadPoolTaskExecutor threadPoolTaskExecutor) {
        this.siteName = siteName;
        this.sourceSiteName = sourceSiteName;
        this.processedCommitsStore = processedCommitsStore;
        this.targetService = targetService;
        this.blobExtension = blobExtension;
        this.threadPoolTaskExecutor = threadPoolTaskExecutor;
    }

    protected void doInit(Configuration config) throws ConfigurationException, DeployerException {
        this.builderConfigurer = new AwsS3ClientBuilderConfigurer(config);
        S3Utilities s3Utilities = this.buildClient(this.builderConfigurer).utilities();
        String uri = HttpUtils.encodeUrlMacro((String)StringUtils.appendIfMissing((String)ConfigUtils.getRequiredStringProperty((Configuration)config, (String)CONFIG_KEY_URL), (CharSequence)DELIMITER, (CharSequence[])new CharSequence[0]));
        this.s3Url = s3Utilities.parseUri(URI.create(uri));
        this.ignoreBlobs = ConfigUtils.getBooleanProperty((Configuration)config, (String)CONFIG_KEY_IGNORE_BLOBS, (Boolean)true);
        Configuration srcTargetConfig = config.subset(CONFIG_KEY_SOURCE_CONFIG);
        String srcUri = HttpUtils.encodeUrlMacro((String)StringUtils.appendIfMissing((String)ConfigUtils.getRequiredStringProperty((Configuration)srcTargetConfig, (String)CONFIG_KEY_URL), (CharSequence)DELIMITER, (CharSequence[])new CharSequence[0]));
        this.srcS3Url = s3Utilities.parseUri(URI.create(srcUri));
        this.srcLocalRepoPath = ConfigUtils.getRequiredStringProperty((Configuration)srcTargetConfig, (String)CONFIG_KEY_LOCAL_REPO_URL);
    }

    protected S3AsyncClient buildClient(AwsS3ClientBuilderConfigurer builderConfigurer) {
        S3AsyncClientBuilder builder = S3AsyncClient.builder();
        builderConfigurer.configureClientBuilder((S3BaseClientBuilder)builder);
        return (S3AsyncClient)builder.build();
    }

    private List<String> getItemPathList(Path repoPath) throws DeployerException {
        List<String> list;
        block8: {
            Stream<Path> paths = Files.walk(repoPath, new FileVisitOption[0]);
            try {
                list = paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(repoPath::relativize).map(Path::toString).filter(p -> !p.startsWith(GIT_ROOT)).filter(p -> !this.ignoreBlobs || !p.endsWith(this.blobExtension)).collect(Collectors.toList());
                if (paths == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (paths != null) {
                        try {
                            paths.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new DeployerException(String.format("Error while retrieving list of paths to copy between buckets during duplication from site '%s' to '%s'", this.sourceSiteName, this.siteName), (Throwable)e);
                }
            }
            paths.close();
        }
        return list;
    }

    protected void doExecute(Target target) throws DeployerException {
        this.logger.info("Starting S3 content duplicate from '{}' for site '{}' to '{}' for site '{}'", new Object[]{this.srcS3Url, this.sourceSiteName, this.s3Url, this.siteName});
        Path repoPath = Path.of(this.srcLocalRepoPath, new String[0]);
        if (!repoPath.toFile().exists()) {
            this.logger.info("Local repository path '{}' does not exist, skipping S3 content duplication", (Object)this.srcLocalRepoPath);
            return;
        }
        List paths = this.getItemPathList(repoPath);
        S3AsyncClient client = this.buildClient(this.builderConfigurer);
        try {
            AwsUtils.copyObjects((S3AsyncClient)client, (ThreadPoolExecutor)this.threadPoolTaskExecutor.getThreadPoolExecutor(), (String)AwsS3Utils.getBucket((S3Uri)this.srcS3Url, (String)this.sourceSiteName), (String)AwsS3Utils.getS3BaseKey((S3Uri)this.srcS3Url, (String)this.sourceSiteName), (String)AwsS3Utils.getBucket((S3Uri)this.s3Url, (String)this.siteName), (String)AwsS3Utils.getS3BaseKey((S3Uri)this.s3Url, (String)this.siteName), (List)paths, (Consumer)AwsUtils.ignoreMissingObject());
        }
        catch (Exception e) {
            throw new DeployerException(String.format("Exception while waiting for S3 content duplication from site '%s' to '%s'", this.sourceSiteName, this.siteName), (Throwable)e);
        }
        this.logger.info("Completed S3 content duplicate from '{}' for site '{}' to '{}' for site '{}'", new Object[]{this.srcS3Url, this.sourceSiteName, this.s3Url, this.siteName});
    }
}

