/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.deployer.impl.processors;

import java.util.ArrayList;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.commons.config.ConfigUtils;
import org.craftercms.commons.config.ConfigurationException;
import org.craftercms.commons.lang.RegexUtils;
import org.craftercms.deployer.api.ChangeSet;
import org.craftercms.deployer.api.Deployment;
import org.craftercms.deployer.api.DeploymentProcessor;
import org.craftercms.deployer.api.Target;
import org.craftercms.deployer.api.exceptions.DeployerException;
import org.craftercms.deployer.impl.TargetImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanNameAware;

public abstract class AbstractDeploymentProcessor
implements DeploymentProcessor,
BeanNameAware {
    private static final Logger logger = LoggerFactory.getLogger(AbstractDeploymentProcessor.class);
    public static final String JUMPING_TO_PARAM_NAME = "jumping_to";
    protected String env;
    protected String siteName;
    protected String targetId;
    protected String name;
    protected String label;
    protected String jumpTo;
    protected String[] includeFiles;
    protected String[] excludeFiles;
    protected boolean alwaysRun;

    public void setEnv(String env) {
        this.env = env;
    }

    public void setSiteName(String siteName) {
        this.siteName = siteName;
    }

    public void setTargetId(String targetId) {
        this.targetId = targetId;
    }

    public void setBeanName(String name) {
        this.name = name;
    }

    public boolean isPostDeployment() {
        return false;
    }

    public void init(Configuration config) throws ConfigurationException, DeployerException {
        this.label = ConfigUtils.getStringProperty((Configuration)config, (String)"processorLabel");
        this.jumpTo = ConfigUtils.getStringProperty((Configuration)config, (String)"jumpTo");
        this.includeFiles = ConfigUtils.getStringArrayProperty((Configuration)config, (String)"includeFiles");
        this.excludeFiles = ConfigUtils.getStringArrayProperty((Configuration)config, (String)"excludeFiles");
        this.alwaysRun = ConfigUtils.getBooleanProperty((Configuration)config, (String)"alwaysRun", (Boolean)false);
        this.doInit(config);
    }

    public void destroy() throws DeployerException {
        this.doDestroy();
    }

    public boolean supportsMode(Deployment.Mode mode) {
        return mode == Deployment.Mode.PUBLISH;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Deployment deployment) {
        ChangeSet originalChangeSet = deployment.getChangeSet();
        ChangeSet filteredChangeSet = null;
        try {
            filteredChangeSet = this.getFilteredChangeSet(originalChangeSet);
        }
        catch (Exception e) {
            logger.error("Processor '{}' for target '{}' failed to filter change set", new Object[]{this.name, this.targetId, e});
            deployment.end(Deployment.Status.FAILURE);
        }
        if (!this.isJumpToActive(deployment) && this.shouldExecute(deployment, filteredChangeSet)) {
            logger.info("----- < {} @ {} > -----", (Object)this.name, (Object)this.targetId);
            try {
                ChangeSet newChangeSet = this.doExecute(deployment, filteredChangeSet, originalChangeSet);
                if (newChangeSet != null) {
                    deployment.setChangeSet(newChangeSet);
                }
                if (StringUtils.isNotEmpty((CharSequence)this.jumpTo)) {
                    this.startJumpTo(deployment);
                }
            }
            catch (Exception e) {
                logger.error("Processor '" + this.name + "' for target '" + this.targetId + "' failed", (Throwable)e);
            }
            finally {
                logger.info("----- </ {} @ {} > -----", (Object)this.name, (Object)this.targetId);
            }
        }
    }

    protected ChangeSet getFilteredChangeSet(ChangeSet changeSet) {
        if (changeSet != null && (ArrayUtils.isNotEmpty((Object[])this.includeFiles) || ArrayUtils.isNotEmpty((Object[])this.excludeFiles))) {
            ArrayList<String> matchedCreatedFiles = new ArrayList<String>();
            ArrayList<String> matchedUpdatedFiles = new ArrayList<String>();
            ArrayList<String> matchedDeletedFiles = new ArrayList<String>();
            for (String path : changeSet.getCreatedFiles()) {
                if (!this.shouldIncludeFile(path)) continue;
                matchedCreatedFiles.add(path);
            }
            for (String path : changeSet.getUpdatedFiles()) {
                if (!this.shouldIncludeFile(path)) continue;
                matchedUpdatedFiles.add(path);
            }
            for (String path : changeSet.getDeletedFiles()) {
                if (!this.shouldIncludeFile(path)) continue;
                matchedDeletedFiles.add(path);
            }
            ChangeSet filteredChangeSet = new ChangeSet(matchedCreatedFiles, matchedUpdatedFiles, matchedDeletedFiles);
            filteredChangeSet.setUpdateDetails(changeSet.getUpdateDetails());
            filteredChangeSet.setUpdateLog(changeSet.getUpdateLog());
            return filteredChangeSet;
        }
        return changeSet;
    }

    protected boolean shouldIncludeFile(String file) {
        return !(!ArrayUtils.isEmpty((Object[])this.includeFiles) && !RegexUtils.matchesAny((String)file, (String[])this.includeFiles) || !ArrayUtils.isEmpty((Object[])this.excludeFiles) && RegexUtils.matchesAny((String)file, (String[])this.excludeFiles));
    }

    protected boolean isJumpToActive(Deployment deployment) {
        String jumpingTo = (String)deployment.getParam(JUMPING_TO_PARAM_NAME);
        if (StringUtils.isEmpty((CharSequence)jumpingTo)) {
            return false;
        }
        if (jumpingTo.equals(this.label)) {
            deployment.removeParam(JUMPING_TO_PARAM_NAME);
            return false;
        }
        return true;
    }

    protected void startJumpTo(Deployment deployment) {
        logger.info("Jumping to processor of target '" + this.targetId + "' with label '" + this.jumpTo + "'");
        deployment.addParam(JUMPING_TO_PARAM_NAME, (Object)this.jumpTo);
    }

    protected Object getDeploymentParam(String param) {
        Target target = TargetImpl.getCurrent();
        if (target == null) {
            return null;
        }
        Deployment currentDeployment = target.getCurrentDeployment();
        return currentDeployment == null ? null : currentDeployment.getParam(param);
    }

    protected abstract boolean shouldExecute(Deployment var1, ChangeSet var2);

    protected abstract void doInit(Configuration var1) throws ConfigurationException, DeployerException;

    protected abstract void doDestroy() throws DeployerException;

    protected abstract ChangeSet doExecute(Deployment var1, ChangeSet var2, ChangeSet var3) throws Exception;
}

