/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.deployer.impl.processors;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.commons.config.ConfigUtils;
import org.craftercms.commons.config.ConfigurationException;
import org.craftercms.deployer.api.ChangeSet;
import org.craftercms.deployer.api.Deployment;
import org.craftercms.deployer.api.ProcessorExecution;
import org.craftercms.deployer.api.exceptions.DeployerException;
import org.craftercms.deployer.impl.processors.AbstractMainDeploymentProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandLineProcessor
extends AbstractMainDeploymentProcessor {
    private static final Logger logger = LoggerFactory.getLogger(CommandLineProcessor.class);
    public static final String OPERATION_CREATE = "CREATE";
    public static final String OPERATION_UPDATE = "UPDATE";
    public static final String OPERATION_DELETE = "DELETE";
    protected static final String WORKING_DIR_CONFIG_KEY = "workingDir";
    protected static final String COMMAND_CONFIG_KEY = "command";
    protected static final String PROCESS_TIMEOUT_SECS_CONFIG_KEY = "processTimeoutSecs";
    protected static final String INCLUDE_CHANGES_CONFIG_KEY = "includeChanges";
    protected static final long DEFAULT_PROCESS_TIMEOUT_SECS = 30L;
    private String workingDir;
    private String command;
    private long processTimeoutSecs;
    private boolean includeChanges;

    protected void doInit(Configuration config) throws ConfigurationException {
        this.workingDir = ConfigUtils.getStringProperty((Configuration)config, (String)WORKING_DIR_CONFIG_KEY);
        this.command = ConfigUtils.getRequiredStringProperty((Configuration)config, (String)COMMAND_CONFIG_KEY);
        this.processTimeoutSecs = ConfigUtils.getLongProperty((Configuration)config, (String)PROCESS_TIMEOUT_SECS_CONFIG_KEY, (Long)30L);
        this.includeChanges = config.getBoolean(INCLUDE_CHANGES_CONFIG_KEY, false);
    }

    protected void doDestroy() throws DeployerException {
    }

    protected ChangeSet doMainProcess(Deployment deployment, ProcessorExecution execution, ChangeSet filteredChangeSet, ChangeSet originalChangeSet) throws DeployerException {
        if (this.includeChanges) {
            String site = deployment.getTarget().getSiteName();
            this.processFiles(site, OPERATION_CREATE, filteredChangeSet.getCreatedFiles());
            this.processFiles(site, OPERATION_UPDATE, filteredChangeSet.getUpdatedFiles());
            this.processFiles(site, OPERATION_DELETE, filteredChangeSet.getDeletedFiles());
        } else {
            this.executeProcess("", "", "");
        }
        return null;
    }

    protected void processFiles(String site, String operation, List<String> files) throws DeployerException {
        for (String file : files) {
            this.executeProcess(site, operation, file);
        }
    }

    protected void executeProcess(String site, String operation, String file) throws DeployerException {
        LinkedList<String> fullCommand = new LinkedList<String>();
        Collections.addAll(fullCommand, this.command.split("\\s"));
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{site, operation, file})) {
            fullCommand.add(site);
            fullCommand.add(operation);
            fullCommand.add(file);
        }
        ProcessBuilder processBuilder = new ProcessBuilder(fullCommand);
        if (StringUtils.isNotEmpty((CharSequence)this.workingDir)) {
            processBuilder.directory(new File(this.workingDir));
        }
        processBuilder.redirectErrorStream(true);
        logger.info("Executing command: {}", (Object)this.command);
        try {
            Process process = processBuilder.start();
            process.waitFor(this.processTimeoutSecs, TimeUnit.SECONDS);
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String str;
                while ((str = reader.readLine()) != null) {
                    logger.info("PROCESS OUTPUT: {}", (Object)str);
                }
            }
            logger.info("Process finished with exit code {}", (Object)process.exitValue());
        }
        catch (IOException | InterruptedException e) {
            throw new DeployerException("Error while executing command", (Throwable)e);
        }
    }
}

