/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.deployer.impl.processors;

import java.beans.ConstructorProperties;
import java.nio.file.Path;
import java.time.Instant;
import java.util.Properties;
import org.apache.commons.configuration2.Configuration;
import org.craftercms.commons.config.ConfigUtils;
import org.craftercms.commons.config.ConfigurationException;
import org.craftercms.deployer.api.ChangeSet;
import org.craftercms.deployer.api.Deployment;
import org.craftercms.deployer.api.ProcessorExecution;
import org.craftercms.deployer.api.Target;
import org.craftercms.deployer.api.events.DeploymentEventsStore;
import org.craftercms.deployer.api.exceptions.DeployerException;
import org.craftercms.deployer.impl.processors.AbstractMainDeploymentProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileBasedDeploymentEventProcessor
extends AbstractMainDeploymentProcessor {
    private static final Logger logger = LoggerFactory.getLogger(FileBasedDeploymentEventProcessor.class);
    protected static final String CONFIG_KEY_EVENT_NAME = "eventName";
    protected DeploymentEventsStore<Properties, Path> store;
    protected String deploymentEventsFileUrl;
    protected String eventName;

    @ConstructorProperties(value={"store"})
    public FileBasedDeploymentEventProcessor(DeploymentEventsStore<Properties, Path> store) {
        this.store = store;
    }

    protected void doInit(Configuration config) throws ConfigurationException, DeployerException {
        this.eventName = ConfigUtils.getRequiredStringProperty((Configuration)config, (String)CONFIG_KEY_EVENT_NAME);
    }

    protected ChangeSet doMainProcess(Deployment deployment, ProcessorExecution execution, ChangeSet filteredChangeSet, ChangeSet originalChangeSet) throws DeployerException {
        Target target = deployment.getTarget();
        Properties deploymentEvents = (Properties)this.store.loadDeploymentEvents(target);
        String now = Instant.now().toString();
        deploymentEvents.setProperty(this.eventName, now);
        this.store.saveDeploymentEvents(target, (Object)deploymentEvents);
        logger.info("Event {}={} saved to {}", new Object[]{this.eventName, now, this.store.getSource(target)});
        return null;
    }

    protected void doDestroy() throws DeployerException {
    }
}

