/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.deployer.impl.processors;

import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.commons.config.ConfigUtils;
import org.craftercms.commons.config.ConfigurationException;
import org.craftercms.deployer.api.ChangeSet;
import org.craftercms.deployer.api.Deployment;
import org.craftercms.deployer.api.ProcessorExecution;
import org.craftercms.deployer.api.exceptions.DeployerException;
import org.craftercms.deployer.impl.processors.AbstractMainDeploymentProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FindAndReplaceProcessor
extends AbstractMainDeploymentProcessor {
    private static final Logger logger = LoggerFactory.getLogger(FindAndReplaceProcessor.class);
    protected static final String CONFIG_KEY_TEXT_PATTERN = "textPattern";
    protected static final String CONFIG_KEY_REPLACEMENT = "replacement";
    protected String localRepoUrl;
    protected String textPattern;
    protected String replacement;

    public void setLocalRepoUrl(String localRepoUrl) {
        this.localRepoUrl = localRepoUrl;
    }

    protected void doInit(Configuration config) throws ConfigurationException {
        this.textPattern = ConfigUtils.getRequiredStringProperty((Configuration)config, (String)CONFIG_KEY_TEXT_PATTERN);
        this.replacement = ConfigUtils.getRequiredStringProperty((Configuration)config, (String)CONFIG_KEY_REPLACEMENT);
        this.failDeploymentOnFailure = config.getBoolean("failDeploymentOnFailure", true);
    }

    protected ChangeSet doMainProcess(Deployment deployment, ProcessorExecution execution, ChangeSet filteredChangeSet, ChangeSet originalChangeSet) throws DeployerException {
        logger.info("Performing find & replace. Pattern '{}' will be replaced with '{}'...", (Object)this.textPattern, (Object)this.replacement);
        for (String file : ListUtils.union((List)filteredChangeSet.getCreatedFiles(), (List)filteredChangeSet.getUpdatedFiles())) {
            try {
                Path path = Paths.get(this.localRepoUrl, file);
                String content = new String(Files.readAllBytes(path));
                String updated = content.replaceAll(this.textPattern, this.replacement);
                if (StringUtils.equals((CharSequence)content, (CharSequence)updated)) {
                    logger.debug("No matches found for file {}", (Object)file);
                    continue;
                }
                logger.debug("Writing changes to file {}", (Object)file);
                Files.write(path, updated.getBytes(), new OpenOption[0]);
            }
            catch (Exception e) {
                throw new DeployerException("Error performing find and replace on file " + file, (Throwable)e);
            }
        }
        return null;
    }

    protected void doDestroy() throws DeployerException {
    }
}

