/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.deployer.impl.processors.aws;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.ListUtils;
import org.apache.commons.configuration2.Configuration;
import org.craftercms.commons.config.ConfigUtils;
import org.craftercms.commons.config.ConfigurationException;
import org.craftercms.deployer.api.ChangeSet;
import org.craftercms.deployer.api.Deployment;
import org.craftercms.deployer.api.ProcessorExecution;
import org.craftercms.deployer.api.exceptions.DeployerException;
import org.craftercms.deployer.impl.processors.AbstractMainDeploymentProcessor;
import org.craftercms.deployer.utils.aws.AwsClientBuilderConfigurer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.util.UriUtils;
import software.amazon.awssdk.awscore.client.builder.AwsClientBuilder;
import software.amazon.awssdk.services.cloudfront.CloudFrontClient;
import software.amazon.awssdk.services.cloudfront.CloudFrontClientBuilder;
import software.amazon.awssdk.services.cloudfront.model.CreateInvalidationRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateInvalidationResponse;
import software.amazon.awssdk.services.cloudfront.model.InvalidationBatch;
import software.amazon.awssdk.services.cloudfront.model.Paths;

public class CloudFrontInvalidationProcessor
extends AbstractMainDeploymentProcessor {
    private static final Logger logger = LoggerFactory.getLogger(CloudFrontInvalidationProcessor.class);
    protected static final String CONFIG_KEY_DISTRIBUTIONS = "distributions";
    protected AwsClientBuilderConfigurer builderConfigurer;
    protected String[] distributions;

    protected void doInit(Configuration config) throws ConfigurationException {
        this.builderConfigurer = new AwsClientBuilderConfigurer(config);
        this.distributions = ConfigUtils.getRequiredStringArrayProperty((Configuration)config, (String)CONFIG_KEY_DISTRIBUTIONS);
    }

    protected ChangeSet doMainProcess(Deployment deployment, ProcessorExecution execution, ChangeSet filteredChangeSet, ChangeSet originalChangeSet) throws DeployerException {
        logger.info("Performing Cloudfront invalidation...");
        CloudFrontClient client = this.buildClient();
        List changedFiles = ListUtils.union((List)filteredChangeSet.getUpdatedFiles(), (List)filteredChangeSet.getDeletedFiles());
        if (CollectionUtils.isNotEmpty((Collection)changedFiles)) {
            changedFiles = changedFiles.stream().map(f -> UriUtils.encodePath((String)f, (Charset)StandardCharsets.UTF_8)).collect(Collectors.toList());
            Paths paths = (Paths)Paths.builder().items(changedFiles).quantity(Integer.valueOf(changedFiles.size())).build();
            logger.info("Will invalidate {} files", (Object)changedFiles.size());
            for (String distribution : this.distributions) {
                try {
                    String caller = UUID.randomUUID().toString();
                    logger.info("Creating invalidation for distribution {} with reference {}", (Object)distribution, (Object)caller);
                    InvalidationBatch batch = (InvalidationBatch)InvalidationBatch.builder().paths(paths).callerReference(caller).build();
                    CreateInvalidationRequest request = (CreateInvalidationRequest)CreateInvalidationRequest.builder().distributionId(distribution).invalidationBatch(batch).build();
                    CreateInvalidationResponse result = client.createInvalidation(request);
                    logger.info("Created invalidation {} for distribution {}", (Object)result.invalidation().id(), (Object)distribution);
                }
                catch (Exception e) {
                    throw new DeployerException("Error invalidating changed files for distribution " + distribution, (Throwable)e);
                }
            }
        } else {
            logger.info("No actual files that need to be invalidated");
        }
        return null;
    }

    protected CloudFrontClient buildClient() {
        CloudFrontClientBuilder builder = CloudFrontClient.builder();
        this.builderConfigurer.configureClientBuilder((AwsClientBuilder)builder);
        return (CloudFrontClient)builder.build();
    }

    protected void doDestroy() throws DeployerException {
    }
}

