/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.deployer.impl.processors.git;

import java.io.File;
import java.io.IOException;
import org.apache.commons.configuration2.Configuration;
import org.craftercms.commons.config.ConfigUtils;
import org.craftercms.commons.config.ConfigurationException;
import org.craftercms.commons.git.auth.GitAuthenticationConfigurator;
import org.craftercms.commons.git.utils.AuthConfiguratorFactory;
import org.craftercms.commons.git.utils.GitUtils;
import org.craftercms.deployer.api.ChangeSet;
import org.craftercms.deployer.api.Deployment;
import org.craftercms.deployer.api.exceptions.DeployerException;
import org.craftercms.deployer.impl.processors.AbstractMainDeploymentProcessor;
import org.eclipse.jgit.api.Git;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRemoteGitRepoAwareProcessor
extends AbstractMainDeploymentProcessor {
    protected static final String REMOTE_REPO_URL_CONFIG_KEY = "remoteRepo.url";
    protected static final String REMOTE_REPO_BRANCH_CONFIG_KEY = "remoteRepo.branch";
    protected static final String REMOTE_REPO_USERNAME_CONFIG_KEY = "remoteRepo.username";
    protected static final String REMOTE_REPO_PASSWORD_CONFIG_KEY = "remoteRepo.password";
    protected static final String REMOTE_REPO_SSH_PRV_KEY_PATH_CONFIG_KEY = "remoteRepo.ssh.privateKey.path";
    protected static final String REMOTE_REPO_SSH_PRV_KEY_PASSPHRASE_CONFIG_KEY = "remoteRepo.ssh.privateKey.passphrase";
    private static final Logger logger = LoggerFactory.getLogger(AbstractRemoteGitRepoAwareProcessor.class);
    protected File localRepoFolder;
    protected String remoteRepoUrl;
    protected String remoteRepoBranch;
    protected GitAuthenticationConfigurator authenticationConfigurator;
    protected AuthConfiguratorFactory authConfiguratorFactory;

    public AbstractRemoteGitRepoAwareProcessor(File localRepoFolder, AuthConfiguratorFactory authConfiguratorFactory) {
        this.localRepoFolder = localRepoFolder;
        this.authConfiguratorFactory = authConfiguratorFactory;
    }

    protected void doInit(Configuration config) throws ConfigurationException {
        this.remoteRepoUrl = ConfigUtils.getRequiredStringProperty((Configuration)config, (String)REMOTE_REPO_URL_CONFIG_KEY);
        this.remoteRepoBranch = ConfigUtils.getStringProperty((Configuration)config, (String)REMOTE_REPO_BRANCH_CONFIG_KEY);
        this.authenticationConfigurator = this.createAuthenticationConfigurator(config, this.remoteRepoUrl);
    }

    protected void doDestroy() throws DeployerException {
    }

    protected boolean shouldExecute(Deployment deployment, ChangeSet filteredChangeSet) {
        return deployment.isRunning();
    }

    protected GitAuthenticationConfigurator createAuthenticationConfigurator(Configuration config, String repoUrl) throws ConfigurationException {
        return this.authConfiguratorFactory.forUrl(repoUrl).withUsername(ConfigUtils.getStringProperty((Configuration)config, (String)REMOTE_REPO_USERNAME_CONFIG_KEY)).withPassword(ConfigUtils.getStringProperty((Configuration)config, (String)REMOTE_REPO_PASSWORD_CONFIG_KEY)).withPrivateKeyPath(ConfigUtils.getStringProperty((Configuration)config, (String)REMOTE_REPO_SSH_PRV_KEY_PATH_CONFIG_KEY)).withPrivateKeyPassphrase(ConfigUtils.getStringProperty((Configuration)config, (String)REMOTE_REPO_SSH_PRV_KEY_PASSPHRASE_CONFIG_KEY)).build();
    }

    protected Git openLocalRepository() throws DeployerException {
        try {
            logger.debug("Opening local Git repository at {}", (Object)this.localRepoFolder);
            return GitUtils.openRepository((File)this.localRepoFolder);
        }
        catch (IOException e) {
            throw new DeployerException("Failed to open Git repository at " + String.valueOf(this.localRepoFolder), (Throwable)e);
        }
    }
}

