/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.deployer.impl.processors.opensearch;

import java.beans.ConstructorProperties;
import java.util.List;
import org.craftercms.deployer.impl.processors.AbstractSearchIndexingProcessor;
import org.craftercms.search.commons.exception.SearchException;
import org.craftercms.search.opensearch.OpenSearchAdminService;
import org.craftercms.search.opensearch.OpenSearchService;
import org.craftercms.search.opensearch.exception.OpenSearchException;
import org.opensearch.client.opensearch._types.query_dsl.Query;

public class OpenSearchIndexingProcessor
extends AbstractSearchIndexingProcessor {
    private static final String DEFAULT_LOCAL_ID_FIELD_NAME = "localId";
    private static final String DEFAULT_INHERITS_FROM_FIELD_NAME = "inheritsFrom_smv";
    private static final String DEFAULT_INCLUDED_DESCRIPTORS_FIELD_NAME = "includedDescriptors";
    private static final String DEFAULT_METADATA_PATH_FIELD_NAME = "metadataPath";
    protected String localIdFieldName = "localId";
    protected String inheritsFromFieldName = "inheritsFrom_smv";
    protected String includedDescriptorsFieldName = "includedDescriptors";
    protected String metadataPathFieldName = "metadataPath";
    protected OpenSearchService searchService;
    protected OpenSearchAdminService searchAdminService;

    @ConstructorProperties(value={"searchService", "searchAdminService"})
    public OpenSearchIndexingProcessor(OpenSearchService searchService, OpenSearchAdminService searchAdminService) {
        this.searchService = searchService;
        this.searchAdminService = searchAdminService;
    }

    protected void doCreateIndexIfMissing() {
        if (!this.searchAdminService.indexExists(this.indexId)) {
            this.searchAdminService.createIndex(this.indexId);
        }
    }

    protected void doCommit(String indexId) {
        try {
            this.searchService.refresh(indexId);
        }
        catch (Exception e) {
            throw new SearchException(indexId, "Error committing changes", (Throwable)e);
        }
    }

    protected List<String> getItemsThatInheritDescriptor(String indexId, String descriptorPath) {
        try {
            Query query = Query.of(q -> q.bool(b -> b.filter(f -> f.match(m -> m.field(this.inheritsFromFieldName).query(v -> v.stringValue(descriptorPath)))).mustNot(n -> n.exists(e -> e.field(this.metadataPathFieldName)))));
            return this.searchService.searchField(indexId, this.localIdFieldName, query);
        }
        catch (OpenSearchException e) {
            throw new SearchException(indexId, "Error executing search of descriptors inheriting from " + descriptorPath, (Throwable)e);
        }
    }

    protected List<String> getItemsThatIncludeComponent(String indexId, String componentPath) {
        try {
            Query query = Query.of(q -> q.bool(b -> b.filter(f -> f.match(m -> m.field(this.includedDescriptorsFieldName).query(v -> v.stringValue(componentPath)))).mustNot(n -> n.exists(e -> e.field(this.metadataPathFieldName)))));
            return this.searchService.searchField(indexId, this.localIdFieldName, query);
        }
        catch (OpenSearchException e) {
            throw new SearchException(indexId, "Error executing search of descriptors that include component " + componentPath, (Throwable)e);
        }
    }
}

