/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.deployer.impl.rest;

import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotEmpty;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.commons.config.ConfigurationException;
import org.craftercms.commons.exceptions.InvalidManagementTokenException;
import org.craftercms.commons.rest.RestServiceUtils;
import org.craftercms.commons.rest.Result;
import org.craftercms.commons.validation.annotations.param.EsapiValidatedParam;
import org.craftercms.commons.validation.annotations.param.EsapiValidationType;
import org.craftercms.commons.validation.annotations.param.ValidSiteId;
import org.craftercms.commons.validation.annotations.param.ValidateNoTagsParam;
import org.craftercms.commons.validation.annotations.param.ValidateSecurePathParam;
import org.craftercms.commons.validation.annotations.param.ValidateStringParam;
import org.craftercms.deployer.api.Deployment;
import org.craftercms.deployer.api.DeploymentService;
import org.craftercms.deployer.api.Target;
import org.craftercms.deployer.api.TargetService;
import org.craftercms.deployer.api.exceptions.DeployerException;
import org.craftercms.deployer.api.exceptions.TargetAlreadyExistsException;
import org.craftercms.deployer.api.exceptions.TargetNotFoundException;
import org.craftercms.deployer.api.exceptions.TargetServiceException;
import org.craftercms.deployer.impl.rest.model.CreateTargetRequest;
import org.craftercms.deployer.impl.rest.model.DuplicateTargetRequest;
import org.craftercms.deployer.impl.rest.model.TargetTemplateParams;
import org.craftercms.deployer.utils.BooleanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController
@RequestMapping(value={"/api/1/target"})
public class TargetController {
    public static final String BASE_URL = "/api/1/target";
    public static final String CREATE_TARGET_URL = "/create";
    public static final String CREATE_TARGET_IF_NOT_EXISTS_URL = "/create_if_not_exists";
    public static final String DUPLICATE_TARGET_URL = "/duplicate/{env}/{site_name}";
    public static final String GET_TARGET_URL = "/get/{env}/{site_name}";
    public static final String GET_ALL_TARGETS_URL = "/get-all";
    public static final String DELETE_TARGET_URL = "/delete/{env}/{site_name}";
    public static final String DELETE_IF_EXIST_TARGET_URL = "/delete-if-exists/{env}/{site_name}";
    public static final String DEPLOY_TARGET_URL = "/deploy/{env}/{site_name}";
    public static final String DEPLOY_ALL_TARGETS_URL = "/deploy-all";
    public static final String GET_PENDING_DEPLOYMENTS_URL = "/deployments/get-pending/{env}/{site_name}";
    public static final String GET_CURRENT_DEPLOYMENT_URL = "/deployments/get-current/{env}/{site_name}";
    public static final String GET_ALL_DEPLOYMENTS_URL = "/deployments/get-all/{env}/{site_name}";
    public static final String UNLOCK_TARGET_URL = "/unlock/{env}/{site_name}";
    public static final String RECREATE_INDEX_URL = "/recreate/{env}/{site_name}";
    public static final String REPO_URL_PARAM_NAME = "repo_url";
    public static final String REPO_BRANCH_PARAM_NAME = "repo_branch";
    public static final String REPO_USERNAME_PARAM_NAME = "repo_username";
    public static final String SSH_PRIVATE_KEY_PATH_PARAM_NAME = "ssh_private_key_path";
    public static final String ENGINE_URL_PARAM_NAME = "engine_url";
    public static final String NOTIFICATION_ADDRESSESS_PARAM_NAME = "notification_addresses";
    private static final String DEPLOY_TARGET_VALID_PARAMS = "reprocess_all_files|from_commit_id|deployment_mode|wait_till_done";
    private static final String DEPLOY_ALL_TARGETS_VALID_PARAMS = "reprocess_all_files|deployment_mode|wait_till_done";
    protected final TargetService targetService;
    protected final DeploymentService deploymentService;
    @Value(value="${deployer.main.management.authorizationToken}")
    protected String managementToken;

    @Autowired
    public TargetController(TargetService targetService, DeploymentService deploymentService) {
        this.targetService = targetService;
        this.deploymentService = deploymentService;
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public ResponseEntity<Result> createTarget(@Valid @RequestBody CreateTargetRequest params) throws DeployerException {
        return this.createTarget(params, false);
    }

    @RequestMapping(value={"/create_if_not_exists"}, method={RequestMethod.POST})
    public ResponseEntity<Result> createTargetIfNotExists(@Valid @RequestBody CreateTargetRequest params) throws DeployerException {
        return this.createTarget(params, true);
    }

    @RequestMapping(value={"/get/{env}/{site_name}"}, method={RequestMethod.GET})
    public ResponseEntity<Target> getTarget(@NotBlank @ValidateNoTagsParam @ValidateSecurePathParam @PathVariable(value="env") String env, @NotBlank @EsapiValidatedParam(type=EsapiValidationType.SITE_ID) @PathVariable(value="site_name") String siteName) throws DeployerException {
        Target target = this.targetService.getTarget(env, siteName);
        return new ResponseEntity((Object)target, (MultiValueMap)this.createResponseHeaders("/api/1/target/get/{env}/{site_name}", new Object[]{env, siteName}), (HttpStatusCode)HttpStatus.OK);
    }

    @RequestMapping(value={"/get-all"}, method={RequestMethod.GET})
    public ResponseEntity<List<Target>> getAllTargets() throws DeployerException {
        List targets = this.targetService.getAllTargets();
        return new ResponseEntity((Object)targets, (MultiValueMap)this.createResponseHeaders("/api/1/target/get-all", new Object[0]), (HttpStatusCode)HttpStatus.OK);
    }

    @RequestMapping(value={"/delete/{env}/{site_name}"}, method={RequestMethod.POST})
    public ResponseEntity<Void> deleteTarget(@NotBlank @ValidateNoTagsParam @ValidateSecurePathParam @PathVariable(value="env") String env, @NotBlank @EsapiValidatedParam(type=EsapiValidationType.SITE_ID) @PathVariable(value="site_name") String siteName) throws DeployerException {
        this.targetService.deleteTarget(env, siteName);
        return new ResponseEntity((HttpStatusCode)HttpStatus.NO_CONTENT);
    }

    @RequestMapping(value={"/delete-if-exists/{env}/{site_name}"}, method={RequestMethod.POST})
    public ResponseEntity<Void> deleteTargetIfExists(@NotBlank @ValidateNoTagsParam @ValidateSecurePathParam @PathVariable(value="env") String env, @NotBlank @EsapiValidatedParam(type=EsapiValidationType.SITE_ID) @PathVariable(value="site_name") String siteName) throws DeployerException {
        try {
            this.targetService.deleteTarget(env, siteName);
        }
        catch (TargetNotFoundException targetNotFoundException) {
            // empty catch block
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NO_CONTENT);
    }

    @RequestMapping(value={"/deploy/{env}/{site_name}"}, method={RequestMethod.POST})
    public ResponseEntity<Result> deployTarget(@NotBlank @ValidateNoTagsParam @ValidateSecurePathParam @PathVariable(value="env") String env, @NotBlank @EsapiValidatedParam(type=EsapiValidationType.SITE_ID) @PathVariable(value="site_name") String siteName, @RequestBody(required=false) Map<@ValidateStringParam(whitelistedPatterns={"reprocess_all_files|from_commit_id|deployment_mode|wait_till_done"}) String, Object> params) throws DeployerException {
        if (params == null) {
            params = new HashMap<String, Object>();
        }
        boolean waitTillDone = BooleanUtils.toBoolean((Object)params.remove("wait_till_done"));
        this.deploymentService.deployTarget(env, siteName, waitTillDone, params);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.ACCEPTED).body((Object)Result.OK);
    }

    @RequestMapping(value={"/deploy-all"}, method={RequestMethod.POST})
    public ResponseEntity<Result> deployAllTargets(@RequestBody(required=false) Map<@ValidateStringParam(whitelistedPatterns={"reprocess_all_files|deployment_mode|wait_till_done"}) String, Object> params) throws DeployerException {
        if (params == null) {
            params = new HashMap<String, Object>();
        }
        boolean waitTillDone = BooleanUtils.toBoolean((Object)params.remove("wait_till_done"));
        this.deploymentService.deployAllTargets(waitTillDone, params);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.ACCEPTED).body((Object)Result.OK);
    }

    @RequestMapping(value={"/deployments/get-pending/{env}/{site_name}"}, method={RequestMethod.GET})
    public ResponseEntity<Collection<Deployment>> getPendingDeployments(@NotBlank @ValidateNoTagsParam @ValidateSecurePathParam @PathVariable(value="env") String env, @NotBlank @EsapiValidatedParam(type=EsapiValidationType.SITE_ID) @PathVariable(value="site_name") String siteName) throws DeployerException {
        Target target = this.targetService.getTarget(env, siteName);
        Collection deployments = target.getPendingDeployments();
        return new ResponseEntity((Object)deployments, (MultiValueMap)this.createResponseHeaders("/api/1/target/deployments/get-pending/{env}/{site_name}", new Object[]{env, siteName}), (HttpStatusCode)HttpStatus.OK);
    }

    @RequestMapping(value={"/deployments/get-current/{env}/{site_name}"}, method={RequestMethod.GET})
    public ResponseEntity<Deployment> getCurrentDeployment(@NotBlank @ValidateNoTagsParam @ValidateSecurePathParam @PathVariable(value="env") String env, @NotBlank @EsapiValidatedParam(type=EsapiValidationType.SITE_ID) @PathVariable(value="site_name") String siteName) throws DeployerException {
        Target target = this.targetService.getTarget(env, siteName);
        Deployment deployment = target.getCurrentDeployment();
        return new ResponseEntity((Object)deployment, (MultiValueMap)this.createResponseHeaders("/api/1/target/deployments/get-current/{env}/{site_name}", new Object[]{env, siteName}), (HttpStatusCode)HttpStatus.OK);
    }

    @RequestMapping(value={"/deployments/get-all/{env}/{site_name}"}, method={RequestMethod.GET})
    public ResponseEntity<Collection<Deployment>> getAllDeployments(@NotBlank @ValidateNoTagsParam @ValidateSecurePathParam @PathVariable(value="env") String env, @NotBlank @EsapiValidatedParam(type=EsapiValidationType.SITE_ID) @PathVariable(value="site_name") String siteName) throws DeployerException {
        Target target = this.targetService.getTarget(env, siteName);
        Collection deployments = target.getAllDeployments();
        return new ResponseEntity((Object)deployments, (MultiValueMap)this.createResponseHeaders("/api/1/target/deployments/get-all/{env}/{site_name}", new Object[]{env, siteName}), (HttpStatusCode)HttpStatus.OK);
    }

    @RequestMapping(value={"/recreate/{env}/{site_name}"}, method={RequestMethod.POST})
    public ResponseEntity<Result> recreateIndex(@NotBlank @ValidateNoTagsParam @ValidateSecurePathParam @PathVariable(value="env") String env, @NotBlank @EsapiValidatedParam(type=EsapiValidationType.SITE_ID) @PathVariable(value="site_name") String siteName, @RequestParam String token) throws DeployerException, InvalidManagementTokenException, ConfigurationException {
        this.validateToken(token);
        this.targetService.recreateIndex(env, siteName);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.ACCEPTED).body((Object)Result.OK);
    }

    private Map<String, Object> getTemplateParams(TargetTemplateParams createRequest) {
        HashMap<String, Object> templateParams = new HashMap<String, Object>();
        templateParams.put(REPO_URL_PARAM_NAME, createRequest.getRepoUrl());
        templateParams.put(REPO_BRANCH_PARAM_NAME, createRequest.getRepoBranch());
        templateParams.put(REPO_USERNAME_PARAM_NAME, createRequest.getRepoUsername());
        templateParams.put(SSH_PRIVATE_KEY_PATH_PARAM_NAME, createRequest.getSshPrivateKeyPath());
        templateParams.put(ENGINE_URL_PARAM_NAME, createRequest.getEngineUrl());
        templateParams.put(NOTIFICATION_ADDRESSESS_PARAM_NAME, createRequest.getNotificationAddresses());
        templateParams.putAll(createRequest.getExtraParams());
        return templateParams;
    }

    protected ResponseEntity<Result> createTarget(CreateTargetRequest createRequest, boolean createIfNotExists) throws DeployerException {
        String env = createRequest.getEnv();
        String siteName = createRequest.getSiteName();
        TargetTemplateParams params = createRequest.getTargetTemplateParams();
        boolean replace = params.isReplace();
        String templateName = params.getTemplateName();
        Map templateParams = this.getTemplateParams(params);
        if (createIfNotExists) {
            if (!this.targetService.targetExists(env, siteName)) {
                this.targetService.createTarget(env, siteName, false, templateName, templateParams);
            }
        } else {
            this.targetService.createTarget(env, siteName, replace, templateName, templateParams);
        }
        return new ResponseEntity((Object)Result.OK, (MultiValueMap)this.createResponseHeaders("/api/1/target/get/{env}/{site_name}", new Object[]{env, siteName}), (HttpStatusCode)HttpStatus.CREATED);
    }

    protected HttpHeaders createResponseHeaders(String locationUrlTemplate, Object ... variables) {
        return RestServiceUtils.setLocationHeader((HttpHeaders)new HttpHeaders(), (String)locationUrlTemplate, (Object[])variables);
    }

    @ResponseStatus(value=HttpStatus.OK)
    @PostMapping(value={"/unlock/{env}/{site_name}"})
    public void unlockTarget(@ValidateSecurePathParam @ValidateNoTagsParam @PathVariable(value="env") String env, @EsapiValidatedParam(type=EsapiValidationType.SITE_ID) @PathVariable(value="site_name") String siteName, @RequestParam String token) throws TargetNotFoundException, TargetServiceException, InvalidManagementTokenException {
        this.validateToken(token);
        Target target = this.targetService.getTarget(env, siteName);
        target.unlock();
    }

    @ResponseStatus(value=HttpStatus.CREATED)
    @PostMapping(value={"/duplicate/{env}/{site_name}"})
    public ResponseEntity<Result> duplicateTarget(@NotEmpty @ValidSiteId @PathVariable(value="env") String env, @ValidSiteId @PathVariable(value="site_name") String sourceSiteName, @Valid @RequestBody DuplicateTargetRequest duplicateTargetRequest) throws TargetServiceException, TargetAlreadyExistsException, TargetNotFoundException {
        TargetTemplateParams params = duplicateTargetRequest.getTargetTemplateParams();
        this.targetService.duplicateTarget(env, sourceSiteName, duplicateTargetRequest.getSiteName(), params.isReplace(), params.getTemplateName(), this.getTemplateParams(params));
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)Result.OK);
    }

    protected void validateToken(String token) throws InvalidManagementTokenException {
        if (StringUtils.isEmpty((CharSequence)token) || !StringUtils.equals((CharSequence)token, (CharSequence)this.managementToken)) {
            throw new InvalidManagementTokenException("Management authorization failed, invalid token.");
        }
    }
}

