/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.deployer.impl.tasks;

import org.craftercms.deployer.api.TargetService;
import org.craftercms.deployer.api.exceptions.DeployerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(value={"deployer.main.targets.scan.scheduling.enabled"})
public class TargetScanTask {
    private static final Logger logger = LoggerFactory.getLogger(TargetScanTask.class);
    @Autowired
    protected TargetService targetService;

    @Scheduled(cron="${deployer.main.targets.scan.scheduling.cron}")
    public void scanTargets() {
        try {
            this.targetService.resolveTargets();
        }
        catch (DeployerException e) {
            logger.error("Scheduled target scan failed", (Throwable)e);
        }
    }
}

