/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.deployer.impl.upgrade.pipeline;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import org.craftercms.commons.upgrade.UpgradeOperation;
import org.craftercms.commons.upgrade.exception.UpgradeException;
import org.craftercms.commons.upgrade.impl.UpgradeContext;
import org.craftercms.commons.upgrade.impl.pipeline.DefaultUpgradePipelineImpl;
import org.craftercms.deployer.api.Target;
import org.craftercms.deployer.impl.upgrade.TargetUpgradeContext;

public class TargetUpgradePipeline
extends DefaultUpgradePipelineImpl<Target> {
    public TargetUpgradePipeline(String name, List<UpgradeOperation<Target>> upgradeOperations) {
        super(name, upgradeOperations);
    }

    public void execute(UpgradeContext<Target> context) throws UpgradeException {
        try {
            if (!this.isEmpty()) {
                this.createConfigurationBackup((TargetUpgradeContext)context);
            }
        }
        catch (Exception e) {
            throw new UpgradeException("Error creating configuration backup for target " + ((Target)context.getTarget()).getId());
        }
        super.execute(context);
    }

    protected void createConfigurationBackup(TargetUpgradeContext context) throws IOException {
        Path configurationFile = ((Target)context.getTarget()).getConfigurationFile().toPath();
        String configurationPath = configurationFile.toAbsolutePath().toString();
        String backupPath = configurationPath + "." + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMdd'.'A")) + ".backup";
        Files.copy(configurationFile, Paths.get(backupPath, new String[0]), new CopyOption[0]);
    }
}

