/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.deployer.utils.aws;

import java.net.URI;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.commons.config.ConfigUtils;
import org.craftercms.commons.config.ConfigurationException;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.awscore.client.builder.AwsClientBuilder;
import software.amazon.awssdk.regions.Region;

public class AwsClientBuilderConfigurer<ClientBuilderSubclass extends AwsClientBuilder> {
    public static final String CONFIG_KEY_REGION = "region";
    public static final String CONFIG_KEY_ENDPOINT = "endpoint";
    public static final String CONFIG_KEY_ACCESS_KEY = "accessKey";
    public static final String CONFIG_KEY_SECRET_KEY = "secretKey";
    protected String region;
    protected String endpoint;
    protected String accessKey;
    protected String secretKey;

    public AwsClientBuilderConfigurer(Configuration config) throws ConfigurationException {
        if (config.containsKey(CONFIG_KEY_REGION)) {
            this.region = ConfigUtils.getStringProperty((Configuration)config, (String)CONFIG_KEY_REGION);
        }
        if (config.containsKey(CONFIG_KEY_ENDPOINT)) {
            this.endpoint = ConfigUtils.getStringProperty((Configuration)config, (String)CONFIG_KEY_ENDPOINT);
        }
        if (config.containsKey(CONFIG_KEY_ACCESS_KEY) && config.containsKey(CONFIG_KEY_SECRET_KEY)) {
            this.accessKey = ConfigUtils.getStringProperty((Configuration)config, (String)CONFIG_KEY_ACCESS_KEY);
            this.secretKey = ConfigUtils.getStringProperty((Configuration)config, (String)CONFIG_KEY_SECRET_KEY);
        }
    }

    public void configureClientBuilder(ClientBuilderSubclass builder) {
        if (StringUtils.isNotEmpty((CharSequence)this.endpoint)) {
            builder.endpointOverride(URI.create(this.endpoint));
        } else if (StringUtils.isNotEmpty((CharSequence)this.region)) {
            builder.region(Region.of((String)this.region));
        }
        if (StringUtils.isNotEmpty((CharSequence)this.accessKey) && StringUtils.isNotEmpty((CharSequence)this.secretKey)) {
            builder.credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)this.accessKey, (String)this.secretKey)));
        }
    }
}

