/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.deployer.utils.aws;

import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.craftercms.deployer.api.exceptions.DeployerException;
import org.craftercms.deployer.utils.aws.AwsClientBuilderConfigurer;
import software.amazon.awssdk.awscore.client.builder.AwsClientBuilder;
import software.amazon.awssdk.services.cloudformation.CloudFormationClient;
import software.amazon.awssdk.services.cloudformation.CloudFormationClientBuilder;
import software.amazon.awssdk.services.cloudformation.model.DescribeStacksRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeStacksResponse;
import software.amazon.awssdk.services.cloudformation.model.Stack;

/*
 * Exception performing whole class analysis ignored.
 */
public class AwsCloudFormationUtils {
    private AwsCloudFormationUtils() {
    }

    public static CloudFormationClient buildClient(AwsClientBuilderConfigurer builderConfigurer) {
        CloudFormationClientBuilder builder = CloudFormationClient.builder();
        builderConfigurer.configureClientBuilder((AwsClientBuilder)builder);
        return (CloudFormationClient)builder.build();
    }

    public static boolean stackExists(CloudFormationClient cloudFormation, String stackName) throws DeployerException {
        return AwsCloudFormationUtils.getStack((CloudFormationClient)cloudFormation, (String)stackName) != null;
    }

    public static Stack getStack(CloudFormationClient cloudFormation, String stackName) throws DeployerException {
        try {
            DescribeStacksRequest request = (DescribeStacksRequest)DescribeStacksRequest.builder().stackName(stackName).build();
            DescribeStacksResponse result = cloudFormation.describeStacks(request);
            List stacks = result.stacks();
            if (CollectionUtils.isNotEmpty((Collection)stacks)) {
                return (Stack)stacks.get(0);
            }
            return null;
        }
        catch (Exception e) {
            if (e.getMessage().matches("(.*)" + stackName + "(.*)does not exist(.*)")) {
                return null;
            }
            throw new DeployerException("Error while getting CloudFormation stack " + stackName, (Throwable)e);
        }
    }
}

