/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.deployer.utils.config.profiles;

import java.beans.ConstructorProperties;
import org.craftercms.commons.config.ConfigurationException;
import org.craftercms.commons.config.ConfigurationMapper;
import org.craftercms.commons.config.ConfigurationProvider;
import org.craftercms.commons.config.profiles.ConfigurationProfile;
import org.craftercms.commons.config.profiles.ConfigurationProfileLoader;

public class ConfigurationProfileLoaderImpl<T extends ConfigurationProfile>
implements ConfigurationProfileLoader<T> {
    private String profilesModule;
    private String profilesUrl;
    private ConfigurationMapper<T> profileMapper;
    private ConfigurationProvider configurationProvider;

    @ConstructorProperties(value={"profilesModule", "profilesUrl", "profileMapper", "configurationProvider"})
    public ConfigurationProfileLoaderImpl(String profilesModule, String profilesUrl, ConfigurationMapper<T> profileMapper, ConfigurationProvider configurationProvider) {
        this.profilesModule = profilesModule;
        this.profilesUrl = profilesUrl;
        this.profileMapper = profileMapper;
        this.configurationProvider = configurationProvider;
    }

    public T loadProfile(String id) throws ConfigurationException {
        try {
            return (T)((ConfigurationProfile)this.profileMapper.readConfig(this.configurationProvider, this.profilesModule, this.profilesUrl, null, id));
        }
        catch (Exception e) {
            throw new ConfigurationException("Error while loading profile " + id + " from configuration at " + this.profilesUrl, (Throwable)e);
        }
    }
}

