/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.deployer.utils.config.profiles;

import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.craftercms.commons.config.ConfigurationProvider;
import org.craftercms.core.service.ContentStoreService;
import org.craftercms.core.service.Context;
import org.springframework.beans.factory.ObjectFactory;

public class ConfigurationProviderImpl
implements ConfigurationProvider {
    protected ObjectFactory<Context> contextFactory;
    protected ContentStoreService contentStoreService;
    protected String siteName;

    @ConstructorProperties(value={"contextFactory", "contentStoreService", "siteName"})
    public ConfigurationProviderImpl(ObjectFactory<Context> contextFactory, ContentStoreService contentStoreService, String siteName) {
        this.contextFactory = contextFactory;
        this.contentStoreService = contentStoreService;
        this.siteName = siteName;
    }

    public boolean configExists(String path) {
        return this.contentStoreService.exists((Context)this.contextFactory.getObject(), path);
    }

    public InputStream getConfig(String path) throws IOException {
        return this.contentStoreService.getContent((Context)this.contextFactory.getObject(), path).getInputStream();
    }

    public Map<String, String> getLookupVariables() {
        return ((Context)this.contextFactory.getObject()).getConfigLookupVariables();
    }
}

