/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.deployer.utils.core;

import java.util.Map;
import org.craftercms.core.service.ContentStoreService;
import org.craftercms.core.service.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.ObjectFactory;

public class SingletonContextFactory
implements ObjectFactory<Context>,
DisposableBean {
    private static final String SITE_NAME_CONFIG_VARIABLE = "siteName";
    private static final String SITE_ID_CONFIG_VARIABLE = "siteId";
    private static final Logger logger = LoggerFactory.getLogger(SingletonContextFactory.class);
    private String targetId;
    private String siteName;
    private String localRepoUrl;
    private ContentStoreService contentStoreService;
    private boolean xmlMergingEnabled;
    private boolean enableCache = false;
    private int maxAllowedItemsInCache = 0;
    private Context context;

    public void setTargetId(String targetId) {
        this.targetId = targetId;
    }

    public void setSiteName(String siteName) {
        this.siteName = siteName;
    }

    public void setLocalRepoUrl(String localRepoUrl) {
        this.localRepoUrl = localRepoUrl;
    }

    public void setContentStoreService(ContentStoreService contentStoreService) {
        this.contentStoreService = contentStoreService;
    }

    public void setXmlMergingEnabled(boolean xmlMergingEnabled) {
        this.xmlMergingEnabled = xmlMergingEnabled;
    }

    public void setEnableCache(boolean enableCache) {
        this.enableCache = enableCache;
    }

    public void setMaxAllowedItemsInCache(int maxAllowedItemsInCache) {
        this.maxAllowedItemsInCache = maxAllowedItemsInCache;
    }

    public Context getObject() throws BeansException {
        if (this.context == null) {
            try {
                Map<String, String> configVariables = Map.of(SITE_NAME_CONFIG_VARIABLE, this.siteName, SITE_ID_CONFIG_VARIABLE, this.siteName);
                this.context = this.contentStoreService.getContext(this.targetId, "filesystem", this.localRepoUrl, this.xmlMergingEnabled, this.enableCache, this.maxAllowedItemsInCache, true, configVariables);
                logger.debug("Content store context created: {}", (Object)this.context);
            }
            catch (Exception e) {
                throw new BeanCreationException("Unable to create context for content store @ " + this.localRepoUrl, (Throwable)e);
            }
        }
        return this.context;
    }

    public void destroy() {
        if (this.context != null) {
            try {
                this.contentStoreService.destroyContext(this.context);
                logger.debug("Content store context destroyed: {}", (Object)this.context);
            }
            catch (Exception e) {
                logger.warn("Unable to destroy context " + String.valueOf(this.context), (Throwable)e);
            }
        }
    }
}

