/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.deployer.utils.opensearch;

import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.lang3.ArrayUtils;
import org.craftercms.deployer.utils.opensearch.OpenSearchClusterConfig;

public class OpenSearchConfig {
    public static final String CONFIG_KEY_GLOBAL_CLUSTER = "target.search.openSearch";
    public static final String CONFIG_KEY_READ_CLUSTER = "target.search.openSearch.readCluster";
    public static final String CONFIG_KEY_WRITE_CLUSTERS = "target.search.openSearch.writeClusters";
    public static final String CONFIG_KEY_LOCALE_MAPPING = "target.search.openSearch.locale.mapping";
    public static final String CONFIG_KEY_INDEX_SETTINGS = "target.search.openSearch.indexSettings";
    public static final String CONFIG_KEY_KEY = "key";
    public static final String CONFIG_KEY_VALUE = "value";
    public final OpenSearchClusterConfig globalCluster;
    public final OpenSearchClusterConfig readCluster;
    public final List<OpenSearchClusterConfig> writeClusters;
    public final Map<String, String> localeMapping = new HashMap();
    public final Map<String, String> indexSettings;

    @ConstructorProperties(value={"config"})
    public OpenSearchConfig(HierarchicalConfiguration<?> config) {
        this.globalCluster = !CollectionUtils.isEmpty((Collection)config.childConfigurationsAt(CONFIG_KEY_GLOBAL_CLUSTER)) ? new OpenSearchClusterConfig(config.configurationAt(CONFIG_KEY_GLOBAL_CLUSTER)) : new OpenSearchClusterConfig();
        this.readCluster = !CollectionUtils.isEmpty((Collection)config.childConfigurationsAt(CONFIG_KEY_READ_CLUSTER)) ? new OpenSearchClusterConfig(config.configurationAt(CONFIG_KEY_READ_CLUSTER), this.globalCluster.username, this.globalCluster.password, this.globalCluster.connectTimeout, this.globalCluster.socketTimeout, this.globalCluster.threadCount, this.globalCluster.keepAlive, this.globalCluster.maxTotalConnections, this.globalCluster.maxConnectionsPerRoute) : new OpenSearchClusterConfig();
        this.writeClusters = config.configurationsAt(CONFIG_KEY_WRITE_CLUSTERS).stream().map(cluster -> new OpenSearchClusterConfig(cluster, this.globalCluster.username, this.globalCluster.password, this.globalCluster.connectTimeout, this.globalCluster.socketTimeout, this.globalCluster.threadCount, this.globalCluster.keepAlive, this.globalCluster.maxTotalConnections, this.globalCluster.maxConnectionsPerRoute)).collect(Collectors.toList());
        if (this.useSingleCluster() && ArrayUtils.isEmpty((Object[])this.globalCluster.urls)) {
            throw new IllegalStateException("Invalid OpenSearch configuration");
        }
        HierarchicalConfiguration mapping = config.configurationAt(CONFIG_KEY_LOCALE_MAPPING);
        mapping.getKeys().forEachRemaining(arg_0 -> this.lambda$new$1((Configuration)mapping, arg_0));
        this.indexSettings = new HashMap();
        config.configurationsAt(CONFIG_KEY_INDEX_SETTINGS).forEach(settingConfig -> this.indexSettings.put(settingConfig.getString(CONFIG_KEY_KEY), settingConfig.getString(CONFIG_KEY_VALUE)));
    }

    public boolean useSingleCluster() {
        return ArrayUtils.isEmpty((Object[])this.readCluster.urls) || CollectionUtils.isEmpty((Collection)this.writeClusters);
    }

    public Map<String, String> getLocaleMapping() {
        return this.localeMapping;
    }

    private /* synthetic */ void lambda$new$1(Configuration mapping, String key) {
        this.localeMapping.put(key, mapping.getString(key));
    }
}

