/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.deployer.utils.opensearch.legacy;

import java.beans.ConstructorProperties;
import org.craftercms.deployer.utils.opensearch.legacy.AbstractOpenSearchFactory;
import org.craftercms.deployer.utils.opensearch.legacy.OpenSearchConfig;
import org.craftercms.search.opensearch.OpenSearchAdminService;
import org.craftercms.search.opensearch.impl.MultiOpenSearchAdminServiceImpl;
import org.craftercms.search.opensearch.impl.OpenSearchAdminServiceImpl;
import org.opensearch.client.RestHighLevelClient;
import org.springframework.core.io.Resource;

public class OpenSearchAdminServiceFactory
extends AbstractOpenSearchFactory<OpenSearchAdminService> {
    protected Resource authoringMapping;
    protected Resource previewMapping;
    protected String authoringNamePattern;

    @ConstructorProperties(value={"config", "authoringMapping", "previewMapping", "authoringNamePattern"})
    public OpenSearchAdminServiceFactory(OpenSearchConfig config, Resource authoringMapping, Resource previewMapping, String authoringNamePattern) {
        super(config);
        this.authoringMapping = authoringMapping;
        this.previewMapping = previewMapping;
        this.authoringNamePattern = authoringNamePattern;
    }

    public Class<?> getObjectType() {
        return OpenSearchAdminService.class;
    }

    protected OpenSearchAdminService doCreateSingleInstance(RestHighLevelClient client) {
        OpenSearchAdminServiceImpl openSearchAdminService = new OpenSearchAdminServiceImpl(this.authoringMapping, this.previewMapping, this.authoringNamePattern, this.config.getLocaleMapping(), this.config.indexSettings, this.config.ignoredSettings, client);
        openSearchAdminService.setReindexSlices(this.config.reindexSlices);
        openSearchAdminService.setReindexTimeoutSeconds(this.config.reindexTimeoutSeconds);
        return openSearchAdminService;
    }

    protected OpenSearchAdminService doCreateMultiInstance(RestHighLevelClient readClient, RestHighLevelClient[] writeClients) {
        MultiOpenSearchAdminServiceImpl openSearchAdminService = new MultiOpenSearchAdminServiceImpl(this.authoringMapping, this.previewMapping, this.authoringNamePattern, this.config.getLocaleMapping(), readClient, this.config.indexSettings, this.config.ignoredSettings, writeClients);
        openSearchAdminService.setReindexSlices(this.config.reindexSlices);
        openSearchAdminService.setReindexTimeoutSeconds(this.config.reindexTimeoutSeconds);
        return openSearchAdminService;
    }
}

