/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.searchrelevance.dao;

import java.io.IOException;
import org.opensearch.action.StepListener;
import org.opensearch.action.delete.DeleteResponse;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.searchrelevance.exception.SearchRelevanceException;
import org.opensearch.searchrelevance.indices.SearchRelevanceIndices;
import org.opensearch.searchrelevance.indices.SearchRelevanceIndicesManager;
import org.opensearch.searchrelevance.model.Judgment;

public class JudgmentDao {
    private final SearchRelevanceIndicesManager searchRelevanceIndicesManager;

    @Inject
    public JudgmentDao(SearchRelevanceIndicesManager searchRelevanceIndicesManager) {
        this.searchRelevanceIndicesManager = searchRelevanceIndicesManager;
    }

    public void createIndexIfAbsent(StepListener<Void> stepListener) {
        this.searchRelevanceIndicesManager.createIndexIfAbsent(SearchRelevanceIndices.JUDGMENT, stepListener);
    }

    public void putJudgement(Judgment judgment, ActionListener listener) {
        if (judgment == null) {
            listener.onFailure((Exception)((Object)new SearchRelevanceException("Judgment cannot be null", RestStatus.BAD_REQUEST)));
            return;
        }
        try {
            this.searchRelevanceIndicesManager.putDoc(judgment.getId(), judgment.toXContent(XContentFactory.jsonBuilder(), ToXContent.EMPTY_PARAMS), SearchRelevanceIndices.JUDGMENT, listener);
        }
        catch (IOException e) {
            throw new SearchRelevanceException("Failed to store judgment", e, RestStatus.INTERNAL_SERVER_ERROR);
        }
    }

    public void updateJudgment(Judgment judgment, ActionListener listener) {
        if (judgment == null) {
            listener.onFailure((Exception)((Object)new SearchRelevanceException("Judgment cannot be null", RestStatus.BAD_REQUEST)));
            return;
        }
        try {
            this.searchRelevanceIndicesManager.updateDoc(judgment.getId(), judgment.toXContent(XContentFactory.jsonBuilder(), ToXContent.EMPTY_PARAMS), SearchRelevanceIndices.JUDGMENT, listener);
        }
        catch (IOException e) {
            throw new SearchRelevanceException("Failed to store judgment", e, RestStatus.INTERNAL_SERVER_ERROR);
        }
    }

    public void deleteJudgment(String judgmentId, ActionListener<DeleteResponse> listener) {
        this.searchRelevanceIndicesManager.deleteDocByDocId(judgmentId, SearchRelevanceIndices.JUDGMENT, listener);
    }

    public SearchResponse getJudgment(String judgmentId, ActionListener<SearchResponse> listener) {
        if (judgmentId == null || judgmentId.isEmpty()) {
            listener.onFailure((Exception)((Object)new SearchRelevanceException("judgmentId must not be null or empty", RestStatus.BAD_REQUEST)));
            return null;
        }
        return this.searchRelevanceIndicesManager.getDocByDocId(judgmentId, SearchRelevanceIndices.JUDGMENT, listener);
    }

    public SearchResponse getJudgmentSync(String judgmentId) {
        if (judgmentId == null || judgmentId.isEmpty()) {
            throw new SearchRelevanceException("judgmentId must not be null or empty", RestStatus.BAD_REQUEST);
        }
        return this.searchRelevanceIndicesManager.getDocByDocIdSync(judgmentId, SearchRelevanceIndices.JUDGMENT);
    }

    public SearchResponse listJudgment(SearchSourceBuilder sourceBuilder, ActionListener<SearchResponse> listener) {
        if (sourceBuilder == null) {
            sourceBuilder = new SearchSourceBuilder();
        }
        if (sourceBuilder.query() == null) {
            sourceBuilder.query((QueryBuilder)QueryBuilders.matchAllQuery());
        }
        return this.searchRelevanceIndicesManager.listDocsBySearchRequest(sourceBuilder, SearchRelevanceIndices.JUDGMENT, listener);
    }
}

