/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.executor;

import java.util.Map;
import lombok.Generated;
import org.apache.logging.log4j.ThreadContext;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.sql.executor.QueryId;
import org.opensearch.sql.executor.QueryManager;
import org.opensearch.sql.executor.execution.AbstractPlan;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.client.node.NodeClient;

public class OpenSearchQueryManager
implements QueryManager {
    private final NodeClient nodeClient;
    private static final String SQL_WORKER_THREAD_POOL_NAME = "sql-worker";

    @Override
    public QueryId submit(AbstractPlan queryPlan) {
        this.schedule(this.nodeClient, () -> queryPlan.execute());
        return queryPlan.getQueryId();
    }

    private void schedule(NodeClient client, Runnable task) {
        ThreadPool threadPool = client.threadPool();
        threadPool.schedule(this.withCurrentContext(task), new TimeValue(0L), SQL_WORKER_THREAD_POOL_NAME);
    }

    private Runnable withCurrentContext(Runnable task) {
        Map currentContext = ThreadContext.getImmutableContext();
        return () -> {
            ThreadContext.putAll((Map)currentContext);
            task.run();
        };
    }

    @Generated
    public OpenSearchQueryManager(NodeClient nodeClient) {
        this.nodeClient = nodeClient;
    }
}

