/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.deployer;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Helper;
import com.github.jknack.handlebars.io.CompositeTemplateLoader;
import com.github.jknack.handlebars.io.TemplateLoader;
import com.github.jknack.handlebars.springmvc.SpringTemplateLoader;
import groovy.grape.Grape;
import java.io.File;
import java.nio.file.Path;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import org.apache.commons.collections4.ListUtils;
import org.craftercms.commons.config.ConfigurationResolver;
import org.craftercms.commons.config.ConfigurationResolverImpl;
import org.craftercms.commons.config.EncryptionAwareConfigurationReader;
import org.craftercms.commons.config.PublishingTargetResolver;
import org.craftercms.commons.crypto.CryptoException;
import org.craftercms.commons.crypto.TextEncryptor;
import org.craftercms.commons.crypto.impl.PbkAesTextEncryptor;
import org.craftercms.commons.git.utils.AuthConfiguratorFactory;
import org.craftercms.deployer.api.TargetService;
import org.craftercms.deployer.api.events.DeploymentEventsStore;
import org.craftercms.deployer.impl.ProcessedCommitsStore;
import org.craftercms.deployer.impl.ProcessedCommitsStoreImpl;
import org.craftercms.deployer.impl.ProcessorStateStore;
import org.craftercms.deployer.impl.ProcessorStateStoreImpl;
import org.craftercms.deployer.impl.events.FileBasedDeploymentEventsStore;
import org.craftercms.deployer.utils.core.TargetAwarePublishingTargetResolver;
import org.craftercms.deployer.utils.handlebars.ListHelper;
import org.craftercms.deployer.utils.handlebars.MissingValueHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ImportResource;
import org.springframework.context.annotation.Primary;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.http.MediaType;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.servlet.config.annotation.ContentNegotiationConfigurer;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@SpringBootApplication
@EnableScheduling
@ImportResource(value={"classpath:crafter/core/core-context.xml"})
public class DeployerApplication
implements WebMvcConfigurer {
    public static final String CORE_APP_CONTEXT_LOCATION = "classpath:crafter/core/core-context.xml";
    @Value(value="${deployer.main.taskScheduler.poolSize}")
    private int taskSchedulerPoolSize;
    @Value(value="${deployer.main.targets.config.templates.location}")
    private String targetConfigTemplatesLocation;
    @Value(value="${deployer.main.targets.config.templates.overrideLocation}")
    private String targetConfigTemplatesOverrideLocation;
    @Value(value="${deployer.main.targets.config.templates.suffix}")
    private String targetConfigTemplatesSuffix;
    @Value(value="${deployer.main.targets.config.templates.encoding}")
    private String targetConfigTemplatesEncoding;
    @Value(value="${deployer.main.deployments.processedCommits.folderPath}")
    private File processedCommitsFolder;
    @Value(value="${deployer.main.deployments.processorStates.folderPath}")
    private File processorsStateFolder;
    @Value(value="${deployer.main.deployments.pool.size}")
    private int deploymentPoolSize;
    @Value(value="${deployer.main.deployments.pool.max}")
    private int deploymentPoolMaxSize;
    @Value(value="${deployer.main.deployments.pool.queue}")
    private int deploymentPoolQueue;
    @Value(value="${deployer.main.deployments.pool.name}")
    private String deploymentPoolName;
    @Value(value="${deployer.main.deployments.pool.prefix}")
    private String deploymentPoolPrefix;
    @Value(value="${deployer.main.scripting.sandbox.whitelist.enabled}")
    private boolean whitelistEnabled;
    @Value(value="${deployer.main.scripting.sandbox.whitelist.path}")
    private List<String> whitelistPath;
    @Value(value="${deployer.main.scripting.sandbox.blacklist.enabled}")
    private boolean blacklistEnabled;
    @Value(value="${deployer.main.scripting.sandbox.blacklist.path}")
    private List<String> blacklistPath;
    @Value(value="${deployer.main.scripting.grapes.download.enabled}")
    private boolean grapesDownloadEnabled;
    @Autowired
    private ResourceLoader resourceLoader;
    @Autowired
    private TargetService targetService;

    public static void main(String[] args) {
        SpringApplication.run(DeployerApplication.class, (String[])args);
    }

    @Bean
    public ProcessedCommitsStore processedCommitsStore() {
        ProcessedCommitsStoreImpl store = new ProcessedCommitsStoreImpl();
        store.setStoreFolder(this.processedCommitsFolder);
        return store;
    }

    @Bean
    public ProcessorStateStore processorStateStore() {
        ProcessorStateStoreImpl store = new ProcessorStateStoreImpl();
        store.setStoreFolder(this.processorsStateFolder);
        return store;
    }

    @Bean
    @Primary
    public ObjectMapper objectMapper(Jackson2ObjectMapperBuilder builder) {
        ObjectMapper objectMapper = builder.createXmlMapper(false).build();
        objectMapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        return objectMapper;
    }

    @Bean
    public RestTemplate restTemplate(RestTemplateBuilder builder) {
        return builder.build();
    }

    @Bean(destroyMethod="shutdown")
    public ThreadPoolTaskScheduler taskScheduler() {
        ThreadPoolTaskScheduler taskScheduler = new ThreadPoolTaskScheduler();
        taskScheduler.setPoolSize(this.taskSchedulerPoolSize);
        return taskScheduler;
    }

    @Bean(destroyMethod="shutdownNow")
    public ExecutorService deploymentTaskExecutor() {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setCorePoolSize(this.deploymentPoolSize);
        executor.setMaxPoolSize(this.deploymentPoolMaxSize);
        executor.setQueueCapacity(this.deploymentPoolQueue);
        executor.setThreadGroupName(this.deploymentPoolName);
        executor.setThreadNamePrefix(this.deploymentPoolPrefix);
        executor.initialize();
        return executor.getThreadPoolExecutor();
    }

    @Bean
    public Handlebars targetConfigTemplateEngine(ResourceLoader resourceLoader) {
        SpringTemplateLoader templateOverridesLoader = new SpringTemplateLoader(resourceLoader);
        templateOverridesLoader.setPrefix(this.targetConfigTemplatesOverrideLocation);
        templateOverridesLoader.setSuffix(this.targetConfigTemplatesSuffix);
        SpringTemplateLoader templateLoader = new SpringTemplateLoader(resourceLoader);
        templateLoader.setPrefix(this.targetConfigTemplatesLocation);
        templateLoader.setSuffix(this.targetConfigTemplatesSuffix);
        CompositeTemplateLoader compositeTemplateLoader = new CompositeTemplateLoader(new TemplateLoader[]{templateOverridesLoader, templateLoader});
        Handlebars handlebars = new Handlebars((TemplateLoader)compositeTemplateLoader);
        handlebars.prettyPrint(true);
        handlebars.registerHelper("list", (Helper)ListHelper.INSTANCE);
        handlebars.registerHelperMissing((Helper)MissingValueHelper.INSTANCE);
        return handlebars;
    }

    @Bean(value={"crafter.textEncryptor"})
    public TextEncryptor textEncryptor(@Value(value="${deployer.main.security.encryption.key}") String key, @Value(value="${deployer.main.security.encryption.salt}") String salt) throws CryptoException {
        return new PbkAesTextEncryptor(key, salt);
    }

    @Bean(value={"crafter.configurationReader"})
    public EncryptionAwareConfigurationReader configurationReader(@Autowired TextEncryptor textEncryptor, @Value(value="${deployer.main.config.yamlMaxAliasesForCollections}") int yamlMaxAliasesForCollections) {
        return new EncryptionAwareConfigurationReader(textEncryptor, yamlMaxAliasesForCollections);
    }

    @Bean(value={"crafter.publishingTargetResolver"})
    public PublishingTargetResolver publishingTargetResolver(@Value(value="${deployer.main.targets.config.blob.staging.pattern}") String stagingNamePattern) {
        return new TargetAwarePublishingTargetResolver(stagingNamePattern);
    }

    @Bean(value={"crafter.configurationResolver"})
    public ConfigurationResolver configurationResolver(@Value(value="${deployer.main.config.environment.active}") String environment, @Value(value="${deployer.main.config.environment.basePath}") String basePath, @Value(value="${deployer.main.config.environment.envPath}") String envPath, @Autowired EncryptionAwareConfigurationReader configurationReader) {
        return new ConfigurationResolverImpl(environment, basePath, envPath, configurationReader);
    }

    @Bean
    public DeploymentEventsStore<Properties, Path> deploymentEventsStore(@Value(value="${deployer.main.deployments.events.folderPath}") String folderPath, @Value(value="${deployer.main.deployments.events.filePattern}") String filePattern) {
        return new FileBasedDeploymentEventsStore(folderPath, filePattern);
    }

    public void configureContentNegotiation(ContentNegotiationConfigurer configurer) {
        configurer.defaultContentType(new MediaType[]{MediaType.APPLICATION_JSON});
    }

    @Bean
    public AuthConfiguratorFactory gitAuthenticationConfiguratorFactory(@Value(value="${deployer.main.security.ssh.config}") File sshConfig) {
        return new AuthConfiguratorFactory(sshConfig);
    }

    @Bean
    public Resource groovySandboxWhitelist() {
        if (!this.whitelistEnabled) {
            return null;
        }
        Resource resource = this.findFirstExistingResource(this.whitelistPath);
        if (resource != null) {
            return resource;
        }
        throw new IllegalArgumentException(String.format("Could not find whitelist at '%s'", this.whitelistPath));
    }

    @Bean
    public Resource groovySandboxBlacklist() {
        if (!this.blacklistEnabled) {
            return null;
        }
        Resource resource = this.findFirstExistingResource(this.blacklistPath);
        if (resource != null) {
            return resource;
        }
        throw new IllegalArgumentException(String.format("Could not find blacklist at '%s'", this.blacklistPath));
    }

    private Resource findFirstExistingResource(List<String> paths) {
        for (String path : ListUtils.emptyIfNull(paths)) {
            Resource resource = this.resourceLoader.getResource(path);
            if (!resource.exists()) continue;
            return resource;
        }
        return null;
    }

    @EventListener(value={ContextRefreshedEvent.class}, condition="event.applicationContext.parent == null")
    public void configureGrapesDownload() {
        Grape.setEnableAutoDownload((boolean)this.grapesDownloadEnabled);
    }
}

