/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.deployer.api;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.File;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.craftercms.deployer.api.Deployment;
import org.craftercms.deployer.api.Target;
import org.craftercms.deployer.api.exceptions.TargetNotReadyException;
import org.craftercms.deployer.api.target.event.TargetEvent;
import org.springframework.context.ConfigurableApplicationContext;

public interface Target {
    public static final String INDEX_ID_FORMAT_CONFIG_KEY = "target.search.indexIdFormat";
    public static final String AUTHORING_ENV = "authoring";

    @JsonProperty(value="id")
    public String getId();

    @JsonProperty(value="env")
    public String getEnv();

    @JsonProperty(value="site_name")
    public String getSiteName();

    @JsonProperty(value="load_date")
    public ZonedDateTime getLoadDate();

    @JsonProperty(value="status")
    public Status getStatus();

    @JsonIgnore
    public File getConfigurationFile();

    public long getRuntimeWarningThreshold();

    @JsonIgnore
    public HierarchicalConfiguration<ImmutableNode> getConfiguration();

    @JsonIgnore
    public ConfigurableApplicationContext getApplicationContext();

    public void init();

    public Deployment deploy(boolean var1, Map<String, Object> var2) throws TargetNotReadyException;

    @JsonIgnore
    public Collection<Deployment> getPendingDeployments();

    @JsonIgnore
    public Deployment getCurrentDeployment();

    @JsonIgnore
    public Collection<Deployment> getAllDeployments();

    public int getInitRetryAttempts();

    public void cleanRepo();

    public void close();

    public void delete();

    public void unlock();

    public void handleEvent(TargetEvent<?> var1);
}

