/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.deployer.config;

import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.craftercms.commons.crypto.TextEncryptor;
import org.craftercms.commons.upgrade.UpgradeConfigurationProvider;
import org.craftercms.commons.upgrade.UpgradeOperation;
import org.craftercms.commons.upgrade.UpgradePipelineFactory;
import org.craftercms.commons.upgrade.VersionProvider;
import org.craftercms.commons.upgrade.impl.configuration.YamlConfigurationProvider;
import org.craftercms.deployer.api.Target;
import org.craftercms.deployer.impl.upgrade.TargetVersionProvider;
import org.craftercms.deployer.impl.upgrade.operations.AddLifecycleHookUpgradeOperation;
import org.craftercms.deployer.impl.upgrade.operations.AddProcessorUpgradeOperation;
import org.craftercms.deployer.impl.upgrade.operations.ElasticsearchIndexUpgradeOperation;
import org.craftercms.deployer.impl.upgrade.operations.EncryptionUpgradeOperation;
import org.craftercms.deployer.impl.upgrade.operations.ProcessorUpgradeOperation;
import org.craftercms.deployer.impl.upgrade.operations.RemoveProcessorUpgradeOperation;
import org.craftercms.deployer.impl.upgrade.operations.RemovePropertyUpgradeOperation;
import org.craftercms.deployer.impl.upgrade.operations.ReplaceProcessorUpgradeOperation;
import org.craftercms.deployer.impl.upgrade.pipeline.TargetUpgradePipelineFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.core.io.Resource;

@Configuration
public class UpgradeManagerConfig {
    @Bean
    public VersionProvider versionProvider(@Value(value="${deployer.main.upgrade.pipelines.target.defaultVersion}") String defaultVersion) {
        TargetVersionProvider versionProvider = new TargetVersionProvider();
        versionProvider.setDefaultValue(defaultVersion);
        return versionProvider;
    }

    @Bean
    public UpgradePipelineFactory<Target> upgradePipelineFactory(@Autowired VersionProvider versionProvider, @Autowired UpgradeConfigurationProvider<HierarchicalConfiguration> configurationProvider, @Value(value="${deployer.main.upgrade.pipelines.target.name}") String pipelineName) {
        return new TargetUpgradePipelineFactory(pipelineName, configurationProvider, versionProvider);
    }

    @Bean
    public UpgradeConfigurationProvider<HierarchicalConfiguration> upgradeConfigurationProvider(@Value(value="${deployer.main.upgrade.configuration}") Resource configurationFile) {
        return new YamlConfigurationProvider(configurationFile);
    }

    @Bean
    @Scope(value="prototype")
    public UpgradeOperation<Target> processorUpgrader() {
        return new ProcessorUpgradeOperation();
    }

    @Bean
    @Scope(value="prototype")
    public UpgradeOperation<Target> elasticsearchIndexUpgrader(@Value(value="${deployer.main.upgrade.operations.elasticsearchIndexUpgrade.enabled}") boolean enabled) {
        ElasticsearchIndexUpgradeOperation operation = new ElasticsearchIndexUpgradeOperation();
        operation.setEnabled(enabled);
        return operation;
    }

    @Bean
    @Scope(value="prototype")
    public ReplaceProcessorUpgradeOperation replaceProcessorUpgrader() {
        return new ReplaceProcessorUpgradeOperation();
    }

    @Bean
    @Scope(value="prototype")
    public EncryptionUpgradeOperation encryptionUpgrader(@Autowired TextEncryptor textEncryptor) {
        return new EncryptionUpgradeOperation(textEncryptor);
    }

    @Bean
    @Scope(value="prototype")
    public AddLifecycleHookUpgradeOperation addLifecycleHookUpgrader() {
        return new AddLifecycleHookUpgradeOperation();
    }

    @Bean
    @Scope(value="prototype")
    public AddProcessorUpgradeOperation addProcessorUpgrader() {
        return new AddProcessorUpgradeOperation();
    }

    @Bean
    @Scope(value="prototype")
    public RemovePropertyUpgradeOperation removePropertyUpgrader() {
        return new RemovePropertyUpgradeOperation();
    }

    @Bean
    @Scope(value="prototype")
    public RemoveProcessorUpgradeOperation removeProcessorUpgrader() {
        return new RemoveProcessorUpgradeOperation();
    }
}

