/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.deployer.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.craftercms.deployer.api.Deployment;
import org.craftercms.deployer.api.DeploymentPipeline;
import org.craftercms.deployer.api.DeploymentProcessor;
import org.craftercms.deployer.api.exceptions.DeployerException;
import org.craftercms.deployer.impl.DeploymentServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeploymentPipelineImpl
implements DeploymentPipeline {
    private static final Logger logger = LoggerFactory.getLogger(DeploymentServiceImpl.class);
    protected List<DeploymentProcessor> deploymentProcessors;

    public DeploymentPipelineImpl(List<DeploymentProcessor> deploymentProcessors) {
        this.deploymentProcessors = deploymentProcessors;
    }

    public void destroy() throws DeployerException {
        if (CollectionUtils.isNotEmpty((Collection)this.deploymentProcessors)) {
            for (DeploymentProcessor processor : this.deploymentProcessors) {
                try {
                    processor.destroy();
                }
                catch (Exception e) {
                    logger.error("Failed to destroy processor " + String.valueOf(processor), (Throwable)e);
                }
            }
        }
    }

    public List<DeploymentProcessor> getProcessors() {
        return Collections.unmodifiableList(this.deploymentProcessors);
    }

    public void execute(Deployment deployment) {
        deployment.start();
        try {
            this.executeProcessors(deployment);
            deployment.end(Deployment.Status.SUCCESS);
        }
        catch (Exception e) {
            logger.error("Unexpected error occurred while executing deployment pipeline for target '{}'", (Object)deployment.getTarget().getId(), (Object)e);
            deployment.end(Deployment.Status.FAILURE);
        }
    }

    protected void executeProcessors(Deployment deployment) {
        if (CollectionUtils.isNotEmpty((Collection)this.deploymentProcessors)) {
            for (DeploymentProcessor processor : this.deploymentProcessors) {
                if (!processor.supportsMode(deployment.getMode())) continue;
                processor.execute(deployment);
            }
        }
    }
}

