/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.deployer.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.craftercms.deployer.api.Deployment;
import org.craftercms.deployer.api.DeploymentService;
import org.craftercms.deployer.api.Target;
import org.craftercms.deployer.api.TargetService;
import org.craftercms.deployer.api.exceptions.DeploymentServiceException;
import org.craftercms.deployer.api.exceptions.TargetNotFoundException;
import org.craftercms.deployer.api.exceptions.TargetNotReadyException;
import org.craftercms.deployer.api.exceptions.TargetServiceException;
import org.craftercms.deployer.impl.TargetImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="deploymentService")
public class DeploymentServiceImpl
implements DeploymentService {
    private static final Logger logger = LoggerFactory.getLogger(DeploymentServiceImpl.class);
    protected final TargetService targetService;

    @Autowired
    public DeploymentServiceImpl(TargetService targetService) {
        this.targetService = targetService;
    }

    public List<Deployment> deployAllTargets(boolean waitTillDone, Map<String, Object> params) throws DeploymentServiceException {
        List targets;
        try {
            targets = this.targetService.getAllTargets();
        }
        catch (TargetServiceException e) {
            throw new DeploymentServiceException("Unable to retrieve list of targets", (Throwable)e);
        }
        ArrayList<Deployment> deployments = new ArrayList<Deployment>();
        if (CollectionUtils.isEmpty((Collection)targets)) {
            return deployments;
        }
        for (Target target : targets) {
            try {
                Deployment deployment = target.deploy(waitTillDone, params);
                deployments.add(deployment);
            }
            catch (TargetNotReadyException e) {
                logger.error(e.getMessage());
            }
        }
        return deployments;
    }

    public Deployment deployTarget(String env, String siteName, boolean waitTillDone, Map<String, Object> params) throws TargetNotFoundException, DeploymentServiceException, TargetNotReadyException {
        try {
            return this.targetService.getTarget(env, siteName).deploy(waitTillDone, params);
        }
        catch (TargetServiceException e) {
            throw new DeploymentServiceException(String.format("Error while deploying target '%s'", TargetImpl.getId((String)env, (String)siteName)), (Throwable)e);
        }
    }
}

