/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.deployer.impl;

import java.io.File;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.commons.config.ConfigUtils;
import org.craftercms.commons.config.ConfigurationException;
import org.craftercms.commons.git.utils.GitUtils;
import org.craftercms.deployer.api.Deployment;
import org.craftercms.deployer.api.DeploymentPipeline;
import org.craftercms.deployer.api.Target;
import org.craftercms.deployer.api.exceptions.DeployerException;
import org.craftercms.deployer.api.exceptions.TargetNotReadyException;
import org.craftercms.deployer.api.lifecycle.TargetLifecycleHook;
import org.craftercms.deployer.api.target.event.TargetEvent;
import org.craftercms.deployer.api.target.event.TargetEventListener;
import org.craftercms.deployer.api.target.event.TargetEventListenerResolver;
import org.craftercms.deployer.impl.DeploymentPipelineFactory;
import org.craftercms.deployer.impl.TargetImpl;
import org.craftercms.deployer.impl.TargetLifecycleHooksResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.support.CronTrigger;

/*
 * Exception performing whole class analysis ignored.
 */
public class TargetImpl
implements Target {
    private static final Logger logger = LoggerFactory.getLogger(TargetImpl.class);
    private static final ThreadLocal<Target> threadLocal = new InheritableThreadLocal();
    public static final String TARGET_ID_FORMAT = "%s-%s";
    protected final ZonedDateTime loadDate = ZonedDateTime.now();
    protected final String env;
    protected final String siteName;
    protected final String localRepoPath;
    protected final File configurationFile;
    protected final long runtimeThresholdSeconds;
    protected final HierarchicalConfiguration<ImmutableNode> configuration;
    protected final ConfigurableApplicationContext applicationContext;
    protected final ExecutorService executor;
    protected final TaskScheduler scheduler;
    protected final TargetLifecycleHooksResolver targetLifecycleHooksResolver;
    protected final DeploymentPipelineFactory deploymentPipelineFactory;
    protected final TargetEventListenerResolver targetEventListenerResolver;
    protected volatile Target.Status status;
    protected DeploymentPipeline deploymentPipeline;
    protected ScheduledFuture<?> scheduledDeploymentFuture;
    protected final Queue<Deployment> pendingDeployments;
    protected volatile Deployment currentDeployment;
    protected final Lock deploymentLock;
    protected Map<String, List<TargetEventListener>> eventListeners;
    private int initRetryAttempts;

    public static void setCurrent(Target target) {
        threadLocal.set(target);
    }

    public static Target getCurrent() {
        return (Target)threadLocal.get();
    }

    public static void clear() {
        threadLocal.set(null);
    }

    public static String getId(String env, String siteName) {
        return String.format("%s-%s", siteName, env);
    }

    public TargetImpl(@Value(value="${target.env}") String env, @Value(value="${target.siteName}") String siteName, @Value(value="${target.localRepoPath}") String localRepoPath, @Value(value="${target.configFile}") File configurationFile, @Value(value="${target.runtimeWarningThreshold.seconds}") long runtimeThresholdSeconds, @Autowired TargetEventListenerResolver targetEventListenerResolver, @Autowired HierarchicalConfiguration<ImmutableNode> configuration, @Autowired ConfigurableApplicationContext applicationContext, @Autowired ExecutorService executor, @Autowired TaskScheduler scheduler, @Autowired TargetLifecycleHooksResolver targetLifecycleHooksResolver, @Autowired DeploymentPipelineFactory deploymentPipelineFactory) {
        this.env = env;
        this.siteName = siteName;
        this.localRepoPath = localRepoPath;
        this.configurationFile = configurationFile;
        this.runtimeThresholdSeconds = runtimeThresholdSeconds;
        this.targetEventListenerResolver = targetEventListenerResolver;
        this.configuration = configuration;
        this.applicationContext = applicationContext;
        this.executor = executor;
        this.scheduler = scheduler;
        this.targetLifecycleHooksResolver = targetLifecycleHooksResolver;
        this.deploymentPipelineFactory = deploymentPipelineFactory;
        this.status = Target.Status.CREATED;
        this.pendingDeployments = new ConcurrentLinkedQueue();
        this.deploymentLock = new ReentrantLock();
    }

    public String getEnv() {
        return this.env;
    }

    public String getSiteName() {
        return this.siteName;
    }

    public String getId() {
        return TargetImpl.getId((String)this.env, (String)this.siteName);
    }

    public ZonedDateTime getLoadDate() {
        return this.loadDate;
    }

    public Target.Status getStatus() {
        return this.status;
    }

    public File getConfigurationFile() {
        return this.configurationFile;
    }

    public long getRuntimeWarningThreshold() {
        return this.runtimeThresholdSeconds;
    }

    public HierarchicalConfiguration<ImmutableNode> getConfiguration() {
        return this.configuration;
    }

    public ConfigurableApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void init() {
        MDC.put((String)"targetId", (String)this.getId());
        this.status = Target.Status.INIT_IN_PROGRESS;
        try {
            logger.info("Executing init hooks for target '{}'", (Object)this.getId());
            this.executeHooks(this.getInitHooks());
            logger.info("Creating deployment pipeline for target '{}'", (Object)this.getId());
            this.deploymentPipeline = this.deploymentPipelineFactory.getPipeline(this.configuration, (ApplicationContext)this.applicationContext, "target.deployment.pipeline");
            logger.info("Loading event listeners for target '{}'", (Object)this.getId());
            this.eventListeners = this.targetEventListenerResolver.getListeners(this.configuration, (ApplicationContext)this.applicationContext, "target.eventListeners");
            logger.info("Checking if deployments need to be scheduled for target '{}'", (Object)this.getId());
            this.scheduleDeployments();
            this.status = Target.Status.INIT_COMPLETED;
        }
        catch (Exception e) {
            this.status = Target.Status.INIT_FAILED;
            --this.initRetryAttempts;
            logger.error("Failed to init target '{}'", (Object)this.getId(), (Object)e);
        }
        MDC.remove((String)"targetId");
    }

    void executeCreateHooks() throws ConfigurationException, DeployerException {
        logger.info("Executing create hooks for target '{}'", (Object)this.getId());
        this.executeHooks(this.getCreateHooks());
        logger.info("Create hooks executed for target '{}'", (Object)this.getId());
    }

    void executeDuplicateHooks() throws Exception {
        logger.info("Executing duplicate hooks for target '{}'", (Object)this.getId());
        this.executeHooks(this.getDuplicateHooks());
        logger.info("Duplicate hooks executed for target '{}'", (Object)this.getId());
    }

    private void executeHooks(Collection<TargetLifecycleHook> hooks) throws DeployerException {
        for (TargetLifecycleHook hook : hooks) {
            hook.execute((Target)this);
        }
    }

    public Deployment deploy(boolean waitTillDone, Map<String, Object> params) throws TargetNotReadyException {
        if (this.status == Target.Status.INIT_COMPLETED) {
            Deployment deployment = new Deployment((Target)this, params);
            this.pendingDeployments.add(deployment);
            Future<?> future = this.executor.submit((Runnable)new DeploymentTask(this));
            if (waitTillDone) {
                logger.debug("Waiting for deployment completion...");
                try {
                    future.get();
                }
                catch (InterruptedException | ExecutionException e) {
                    logger.error("Unable to wait for deployment completion", (Throwable)e);
                }
            }
            return deployment;
        }
        throw new TargetNotReadyException("The target is not ready yet for deployments (status " + String.valueOf(this.status) + ")");
    }

    public Collection<Deployment> getPendingDeployments() {
        return new ArrayList<Deployment>(this.pendingDeployments);
    }

    public Deployment getCurrentDeployment() {
        return this.currentDeployment;
    }

    public Collection<Deployment> getAllDeployments() {
        ArrayList<Deployment> deployments = new ArrayList<Deployment>();
        Deployment currentDeployment = this.getCurrentDeployment();
        Collection pendingDeployments = this.getPendingDeployments();
        if (currentDeployment != null) {
            deployments.add(currentDeployment);
        }
        if (CollectionUtils.isNotEmpty((Collection)pendingDeployments)) {
            deployments.addAll(pendingDeployments);
        }
        return deployments;
    }

    public int getInitRetryAttempts() {
        return this.initRetryAttempts;
    }

    public void cleanRepo() {
        MDC.put((String)"targetId", (String)this.getId());
        try {
            logger.info("Cleaning up repo for target {}", (Object)this.getId());
            GitUtils.cleanup((String)this.localRepoPath);
        }
        catch (Exception e) {
            logger.warn("Error cleaning up repo for target {}", (Object)this.getId());
        }
        MDC.remove((String)"targetId");
    }

    public void close() {
        MDC.put((String)"targetId", (String)this.getId());
        try {
            logger.info("Closing target '{}'...", (Object)this.getId());
            logger.info("Stopping current and pending deployments for target '{}'", (Object)this.getId());
            this.stopDeployments();
            logger.info("Releasing resources for target '{}'", (Object)this.getId());
            if (this.scheduledDeploymentFuture != null) {
                this.scheduledDeploymentFuture.cancel(true);
            }
            if (this.deploymentPipeline != null) {
                this.deploymentPipeline.destroy();
            }
            if (this.applicationContext != null) {
                this.applicationContext.close();
            }
        }
        catch (Exception e) {
            logger.error("Failed to close '" + this.getId() + "'", (Throwable)e);
        }
        MDC.remove((String)"targetId");
    }

    public void delete() {
        MDC.put((String)"targetId", (String)this.getId());
        this.status = Target.Status.DELETE_IN_PROGRESS;
        try {
            logger.info("Deleting target '{}'...", (Object)this.getId());
            logger.info("Stopping current and pending deployments for target '{}'", (Object)this.getId());
            this.stopDeployments();
            logger.info("Executing delete hooks for target '{}'", (Object)this.getId());
            this.executeHooks(this.getDeleteHooks());
            logger.info("Releasing resources for target '{}'", (Object)this.getId());
            if (this.scheduledDeploymentFuture != null) {
                this.scheduledDeploymentFuture.cancel(true);
            }
            if (this.deploymentPipeline != null) {
                this.deploymentPipeline.destroy();
            }
            if (this.applicationContext != null) {
                this.applicationContext.close();
            }
        }
        catch (Exception e) {
            logger.error("Failed deleting target '" + this.getId() + "'", (Throwable)e);
        }
        finally {
            this.status = Target.Status.DELETED;
        }
        MDC.remove((String)"targetId");
    }

    public void unlock() {
        MDC.put((String)"targetId", (String)this.getId());
        try {
            if (GitUtils.isRepositoryLocked((String)this.localRepoPath)) {
                GitUtils.unlock((String)this.localRepoPath);
            }
        }
        catch (Exception e) {
            logger.warn("Error unlocking repo for target {}", (Object)this.getId());
        }
        MDC.remove((String)"targetId");
    }

    public void handleEvent(TargetEvent<?> event) {
        logger.info("Handling event '{}' for target '{}'", (Object)event.eventType(), (Object)this.getId());
        Collection eventHandlers = (Collection)this.eventListeners.get(event.eventType());
        if (org.springframework.util.CollectionUtils.isEmpty((Collection)eventHandlers)) {
            logger.info("No event handlers found for event '{}' for target '{}'", (Object)event.eventType(), (Object)this.getId());
            return;
        }
        eventHandlers.forEach(handler -> {
            try {
                handler.handle(event);
            }
            catch (Exception e) {
                logger.error("Error handling event '{}' for target '{}'", new Object[]{event.eventType(), this.getId(), e});
            }
        });
    }

    protected Collection<TargetLifecycleHook> getCreateHooks() throws ConfigurationException, DeployerException {
        return this.getHooksFromConfig("target.lifecycleHooks.create");
    }

    protected Collection<TargetLifecycleHook> getDuplicateHooks() throws ConfigurationException, DeployerException {
        return this.getHooksFromConfig("target.lifecycleHooks.duplicate");
    }

    protected Collection<TargetLifecycleHook> getInitHooks() throws DeployerException, ConfigurationException {
        return this.getHooksFromConfig("target.lifecycleHooks.init");
    }

    protected Collection<TargetLifecycleHook> getDeleteHooks() throws DeployerException, ConfigurationException {
        return this.getHooksFromConfig("target.lifecycleHooks.delete");
    }

    private Collection<TargetLifecycleHook> getHooksFromConfig(String configKey) throws ConfigurationException, DeployerException {
        return this.targetLifecycleHooksResolver.getHooks(this.configuration, (ApplicationContext)this.applicationContext, configKey);
    }

    protected void scheduleDeployments() throws ConfigurationException {
        boolean enabled = ConfigUtils.getBooleanProperty((Configuration)this.configuration, (String)"target.deployment.scheduling.enabled", (Boolean)true);
        String cron = ConfigUtils.getStringProperty((Configuration)this.configuration, (String)"target.deployment.scheduling.cron");
        if (enabled && StringUtils.isNotEmpty((CharSequence)cron)) {
            logger.info("Deployments for target '{}' scheduled with cron {}", (Object)this.getId(), (Object)cron);
            this.scheduledDeploymentFuture = this.scheduler.schedule((Runnable)new ScheduledDeploymentTask(this), (Trigger)new CronTrigger(cron));
        }
    }

    protected void stopDeployments() {
        if (this.currentDeployment != null) {
            this.currentDeployment.end(Deployment.Status.INTERRUPTED);
        }
        if (CollectionUtils.isNotEmpty((Collection)this.pendingDeployments)) {
            Deployment deployment;
            while ((deployment = (Deployment)this.pendingDeployments.poll()) != null) {
                deployment.end(Deployment.Status.INTERRUPTED);
            }
        }
    }

    public void setInitRetryAttempts(int initRetryAttempts) {
        this.initRetryAttempts = initRetryAttempts;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TargetImpl target = (TargetImpl)o;
        return this.env.equals(target.env) && this.siteName.equals(target.siteName) && this.configurationFile.equals(target.configurationFile);
    }

    public int hashCode() {
        return Objects.hash(this.env, this.siteName, this.configurationFile);
    }

    public String toString() {
        return "TargetImpl{env='" + this.env + "', siteName='" + this.siteName + "', configurationFile=" + String.valueOf(this.configurationFile) + "}";
    }
}

