/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.deployer.impl.lifecycle;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.io.FileUtils;
import org.craftercms.commons.config.ConfigurationException;
import org.craftercms.deployer.api.Target;
import org.craftercms.deployer.api.exceptions.DeployerException;
import org.craftercms.deployer.impl.lifecycle.AbstractLifecycleHook;

public class DeleteLocalRepoFolderLifecycleHook
extends AbstractLifecycleHook {
    protected Path localRepoFolder;

    public void setLocalRepoFolder(String localRepoFolder) {
        this.localRepoFolder = Paths.get(localRepoFolder, new String[0]);
    }

    protected void doInit(Configuration config) throws ConfigurationException, DeployerException {
    }

    protected void doExecute(Target target) throws DeployerException {
        try {
            if (Files.exists(this.localRepoFolder, new LinkOption[0])) {
                FileUtils.forceDelete((File)this.localRepoFolder.toFile());
                this.logger.info("Local repo folder {} deleted", (Object)this.localRepoFolder);
            }
        }
        catch (IOException e) {
            throw new DeployerException("Unable to delete local repo folder " + String.valueOf(this.localRepoFolder), (Throwable)e);
        }
    }
}

