/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.deployer.impl.lifecycle.aws;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.commons.config.ConfigUtils;
import org.craftercms.commons.config.ConfigurationException;
import org.craftercms.deployer.api.Target;
import org.craftercms.deployer.api.exceptions.DeployerException;
import org.craftercms.deployer.impl.lifecycle.AbstractLifecycleHook;
import org.craftercms.deployer.utils.aws.AwsClientBuilderConfigurer;
import org.craftercms.deployer.utils.aws.AwsCloudFormationUtils;
import org.springframework.core.io.Resource;
import software.amazon.awssdk.services.cloudformation.CloudFormationClient;
import software.amazon.awssdk.services.cloudformation.model.Capability;
import software.amazon.awssdk.services.cloudformation.model.CreateStackRequest;
import software.amazon.awssdk.services.cloudformation.model.CreateStackResponse;
import software.amazon.awssdk.services.cloudformation.model.Parameter;

public class CreateCloudFormationLifecycleHook
extends AbstractLifecycleHook {
    protected static final String CONFIG_KEY_STACK_NAME = "stackName";
    protected static final String CONFIG_KEY_TEMPLATE_FILENAME = "templateFilename";
    protected static final String CONFIG_KEY_TEMPLATE_PARAMS = "templateParams";
    protected static final String CONFIG_KEY_STACK_CAPABILITIES = "stackCapabilities";
    protected Resource templatesResource;
    protected Resource templatesOverrideResource;
    protected AwsClientBuilderConfigurer builderConfigurer;
    protected String stackName;
    protected String templateFilename;
    protected Collection<Parameter> templateParams = new ArrayList();
    protected List<Capability> stackCapabilities = new ArrayList();

    public void setTemplatesResource(Resource templatesResource) {
        this.templatesResource = templatesResource;
    }

    public void setTemplatesOverrideResource(Resource templatesOverrideResource) {
        this.templatesOverrideResource = templatesOverrideResource;
    }

    public void doInit(Configuration config) throws ConfigurationException {
        this.builderConfigurer = new AwsClientBuilderConfigurer(config);
        this.stackName = ConfigUtils.getRequiredStringProperty((Configuration)config, (String)CONFIG_KEY_STACK_NAME);
        this.templateFilename = ConfigUtils.getRequiredStringProperty((Configuration)config, (String)CONFIG_KEY_TEMPLATE_FILENAME);
        Configuration templateParamsConfig = config.subset(CONFIG_KEY_TEMPLATE_PARAMS);
        if (templateParamsConfig != null) {
            Iterator keys = templateParamsConfig.getKeys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                String value = templateParamsConfig.getString(key);
                this.templateParams.add((Parameter)Parameter.builder().parameterKey(key).parameterValue(value).build());
            }
        }
        this.stackCapabilities = this.loadCapabilities(config);
    }

    private List<Capability> loadCapabilities(Configuration config) throws ConfigurationException {
        String property = ConfigUtils.getStringProperty((Configuration)config, (String)CONFIG_KEY_STACK_CAPABILITIES, (String)"");
        if (StringUtils.isEmpty((CharSequence)property)) {
            return new ArrayList<Capability>();
        }
        return Arrays.stream(property.split(",")).map(String::trim).map(Capability::fromValue).collect(Collectors.toList());
    }

    public void doExecute(Target target) throws DeployerException {
        CloudFormationClient cloudFormation = AwsCloudFormationUtils.buildClient((AwsClientBuilderConfigurer)this.builderConfigurer);
        if (AwsCloudFormationUtils.stackExists((CloudFormationClient)cloudFormation, (String)this.stackName)) {
            this.logger.info("CloudFormation stack '{}' already exists. Skipping create...", (Object)this.stackName);
        } else {
            this.logger.info("Creating CloudFormation stack '{}'", (Object)this.stackName);
            this.createCloudFormationStack(cloudFormation);
        }
    }

    protected void createCloudFormationStack(CloudFormationClient cloudFormation) throws DeployerException {
        try {
            CreateStackRequest.Builder builder = CreateStackRequest.builder().stackName(this.stackName).templateBody(this.getTemplateBody()).parameters(this.templateParams);
            if (CollectionUtils.isNotEmpty((Collection)this.stackCapabilities)) {
                builder.capabilities((Collection)this.stackCapabilities);
            }
            CreateStackRequest request = (CreateStackRequest)builder.build();
            CreateStackResponse result = cloudFormation.createStack(request);
            this.logger.info("Creation of CloudFormation stack '{}' started (stack ID '{}')", (Object)this.stackName, (Object)result.stackId());
        }
        catch (Exception e) {
            throw new DeployerException("Unable to create CloudFormation stack '" + this.stackName + "'", (Throwable)e);
        }
    }

    protected String getTemplateBody() throws DeployerException {
        try {
            Resource templateResource = this.templatesOverrideResource.createRelative(this.templateFilename);
            if (!templateResource.exists() && !(templateResource = this.templatesResource.createRelative(this.templateFilename)).exists()) {
                throw new FileNotFoundException("Unable to resolve template " + this.templateFilename + ". It wasn't found in " + String.valueOf(this.templatesOverrideResource) + " or in " + String.valueOf(this.templatesResource));
            }
            return IOUtils.toString((InputStream)templateResource.getInputStream(), (Charset)StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            throw new DeployerException("Error while retrieving body of template " + this.templateFilename, (Throwable)e);
        }
    }
}

