/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.deployer.impl.lifecycle.aws;

import org.apache.commons.configuration2.Configuration;
import org.apache.commons.lang3.ArrayUtils;
import org.craftercms.commons.config.ConfigUtils;
import org.craftercms.commons.config.ConfigurationException;
import org.craftercms.deployer.api.Target;
import org.craftercms.deployer.api.exceptions.DeployerException;
import org.craftercms.deployer.impl.lifecycle.AbstractLifecycleHook;
import org.craftercms.deployer.utils.aws.AwsClientBuilderConfigurer;
import org.craftercms.deployer.utils.aws.AwsCloudFormationUtils;
import software.amazon.awssdk.services.cloudformation.CloudFormationClient;
import software.amazon.awssdk.services.cloudformation.model.DeleteStackRequest;
import software.amazon.awssdk.services.cloudformation.model.Stack;

public class DeleteCloudFormationLifecycleHook
extends AbstractLifecycleHook {
    protected static final String CONFIG_KEY_STACK_NAME = "stackName";
    protected static final String[] STACK_STATUS_CODES_DELETED = new String[]{"DELETE_COMPLETE", "DELETE_FAILED", "DELETE_IN_PROGRESS"};
    protected AwsClientBuilderConfigurer builderConfigurer;
    protected String stackName;

    public void doInit(Configuration config) throws ConfigurationException {
        this.builderConfigurer = new AwsClientBuilderConfigurer(config);
        this.stackName = ConfigUtils.getRequiredStringProperty((Configuration)config, (String)CONFIG_KEY_STACK_NAME);
    }

    public void doExecute(Target target) throws DeployerException {
        CloudFormationClient cloudFormation = AwsCloudFormationUtils.buildClient((AwsClientBuilderConfigurer)this.builderConfigurer);
        Stack stack = AwsCloudFormationUtils.getStack((CloudFormationClient)cloudFormation, (String)this.stackName);
        if (stack != null && !ArrayUtils.contains((Object[])STACK_STATUS_CODES_DELETED, (Object)stack.stackStatus())) {
            this.logger.info("Deleting CloudFormation stack '{}'", (Object)this.stackName);
            try {
                cloudFormation.deleteStack((DeleteStackRequest)DeleteStackRequest.builder().stackName(this.stackName).build());
                this.logger.info("Deletion of CloudFormation stack '{}' started", (Object)this.stackName);
            }
            catch (Exception e) {
                throw new DeployerException("Error while deleting CloudFormation stack '" + this.stackName + "'", (Throwable)e);
            }
        } else {
            this.logger.info("CloudFormation stack '{}' doesn't exist or has been deleted. Skipping delete...", (Object)this.stackName);
        }
    }
}

