/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.deployer.impl.lifecycle.aws;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.lang3.ArrayUtils;
import org.craftercms.commons.config.ConfigUtils;
import org.craftercms.commons.config.ConfigurationException;
import org.craftercms.deployer.api.Target;
import org.craftercms.deployer.api.exceptions.DeployerException;
import org.craftercms.deployer.impl.lifecycle.AbstractLifecycleHook;
import org.craftercms.deployer.utils.aws.AwsClientBuilderConfigurer;
import org.craftercms.deployer.utils.aws.AwsCloudFormationUtils;
import software.amazon.awssdk.services.cloudformation.CloudFormationClient;
import software.amazon.awssdk.services.cloudformation.model.Output;
import software.amazon.awssdk.services.cloudformation.model.Stack;

public class WaitTillCloudFormationStackUsableLifecycleHook
extends AbstractLifecycleHook {
    public static final int DEFAULT_SECONDS_BEFORE_CHECKING_STATUS = 60;
    protected static final String[] STACK_STATUS_CODES_USABLE = new String[]{"CREATE_COMPLETE", "UPDATE_COMPLETE", "UPDATE_COMPLETE_CLEANUP_IN_PROGRESS", "UPDATE_ROLLBACK_COMPLETE", "UPDATE_ROLLBACK_COMPLETE_CLEANUP_IN_PROGRESS"};
    protected static final String[] STACK_STATUS_CODES_IN_PROGRESS = new String[]{"CREATE_IN_PROGRESS", "REVIEW_IN_PROGRESS", "UPDATE_IN_PROGRESS", "UPDATE_ROLLBACK_IN_PROGRESS"};
    protected static final String CONFIG_KEY_STACK_NAME = "stackName";
    protected static final String CONFIG_KEY_OUTPUT_MAPPINGS = "outputMappings";
    protected static final String CONFIG_KEY_SECONDS_BEFORE_CHECKING_STATUS = "secondsBeforeCheckingStatus";
    protected Configuration targetConfig;
    protected AwsClientBuilderConfigurer builderConfigurer;
    protected String stackName;
    protected Map<String, String> outputMappings = new HashMap();
    protected int secondsBeforeCheckingStatus;

    public void setTargetConfig(Configuration targetConfig) {
        this.targetConfig = targetConfig;
    }

    public void doInit(Configuration config) throws ConfigurationException {
        this.builderConfigurer = new AwsClientBuilderConfigurer(config);
        this.stackName = ConfigUtils.getRequiredStringProperty((Configuration)config, (String)CONFIG_KEY_STACK_NAME);
        this.secondsBeforeCheckingStatus = ConfigUtils.getIntegerProperty((Configuration)config, (String)CONFIG_KEY_SECONDS_BEFORE_CHECKING_STATUS, (Integer)60);
        Configuration outputMappingsConfig = config.subset(CONFIG_KEY_OUTPUT_MAPPINGS);
        if (outputMappingsConfig != null) {
            Iterator keys = outputMappingsConfig.getKeys();
            while (keys.hasNext()) {
                String outputKey = (String)keys.next();
                String configKey = outputMappingsConfig.getString(outputKey);
                this.outputMappings.put(outputKey, configKey);
            }
        }
    }

    public void doExecute(Target target) throws DeployerException {
        CloudFormationClient cloudFormation = AwsCloudFormationUtils.buildClient((AwsClientBuilderConfigurer)this.builderConfigurer);
        while (!this.isTargetDeleted(target) && !this.isStackUsable(cloudFormation)) {
            try {
                Thread.sleep(this.secondsBeforeCheckingStatus * 1000);
            }
            catch (InterruptedException e) {
                this.logger.debug("Thread interrupted while waiting to check again for CloudFormation stack '{}' status", (Object)this.stackName);
            }
        }
    }

    protected boolean isStackUsable(CloudFormationClient cloudFormation) throws DeployerException {
        Stack stack = AwsCloudFormationUtils.getStack((CloudFormationClient)cloudFormation, (String)this.stackName);
        if (stack != null) {
            String statusCode = stack.stackStatusAsString();
            if (ArrayUtils.contains((Object[])STACK_STATUS_CODES_USABLE, (Object)statusCode)) {
                this.logger.info("CloudFormation stack '{}' is usable (status '{}')", (Object)this.stackName, (Object)statusCode);
                this.mapOutputsToConfig(stack.outputs());
                return true;
            }
            if (ArrayUtils.contains((Object[])STACK_STATUS_CODES_IN_PROGRESS, (Object)statusCode)) {
                this.logger.info("CloudFormation stack '" + this.stackName + "' is not yet usable because there's an operation in progress (status '" + statusCode + "')");
                return false;
            }
            throw new DeployerException("CloudFormation stack '" + this.stackName + "' is in an unusable state (status '" + statusCode + ")");
        }
        throw new DeployerException("CloudFormation stack '" + this.stackName + "' doesn't exist");
    }

    protected void mapOutputsToConfig(List<Output> outputs) {
        if (CollectionUtils.isNotEmpty(outputs)) {
            for (Output output : outputs) {
                String configKey = (String)this.outputMappings.get(output.outputKey());
                String outputValue = output.outputValue();
                this.targetConfig.setProperty(configKey, (Object)outputValue);
            }
        }
    }

    protected boolean isTargetDeleted(Target target) {
        return target.getStatus() == Target.Status.DELETE_IN_PROGRESS || target.getStatus() == Target.Status.DELETED;
    }
}

