/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.deployer.impl.processors;

import org.apache.commons.configuration2.Configuration;
import org.craftercms.commons.config.ConfigurationException;
import org.craftercms.deployer.api.ChangeSet;
import org.craftercms.deployer.api.Deployment;
import org.craftercms.deployer.api.ProcessorExecution;
import org.craftercms.deployer.api.exceptions.DeployerException;
import org.craftercms.deployer.impl.processors.AbstractDeploymentProcessor;

public abstract class AbstractMainDeploymentProcessor
extends AbstractDeploymentProcessor {
    public static final String FAIL_DEPLOYMENT_CONFIG_KEY = "failDeploymentOnFailure";
    protected boolean failDeploymentOnFailure;

    public void init(Configuration config) throws ConfigurationException, DeployerException {
        this.failDeploymentOnFailure = config.getBoolean(FAIL_DEPLOYMENT_CONFIG_KEY, false);
        super.init(config);
    }

    protected ChangeSet doExecute(Deployment deployment, ChangeSet filteredChangeSet, ChangeSet originalChangeSet) throws Exception {
        ProcessorExecution execution = new ProcessorExecution(this.name);
        deployment.addProcessorExecution(execution);
        try {
            ChangeSet newChangeSet = this.doMainProcess(deployment, execution, filteredChangeSet, originalChangeSet);
            execution.endExecution(Deployment.Status.SUCCESS);
            return newChangeSet;
        }
        catch (Exception e) {
            execution.setStatusDetails((Object)e.toString());
            execution.endExecution(Deployment.Status.FAILURE);
            if (this.failDeploymentOnProcessorFailure()) {
                deployment.end(Deployment.Status.FAILURE);
            }
            throw e;
        }
    }

    protected boolean shouldExecute(Deployment deployment, ChangeSet filteredChangeSet) {
        return deployment.isRunning() && (this.alwaysRun || filteredChangeSet != null && !filteredChangeSet.isEmpty());
    }

    protected abstract ChangeSet doMainProcess(Deployment var1, ProcessorExecution var2, ChangeSet var3, ChangeSet var4) throws DeployerException;

    protected boolean failDeploymentOnProcessorFailure() {
        return this.failDeploymentOnFailure;
    }
}

