/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.deployer.impl.processors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.regex.Pattern;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.commons.config.ConfigUtils;
import org.craftercms.commons.config.ConfigurationException;
import org.craftercms.core.service.CacheService;
import org.craftercms.core.service.ContentStoreService;
import org.craftercms.core.service.Context;
import org.craftercms.deployer.api.ChangeSet;
import org.craftercms.deployer.api.Deployment;
import org.craftercms.deployer.api.ProcessorExecution;
import org.craftercms.deployer.api.exceptions.DeployerException;
import org.craftercms.deployer.impl.processors.AbstractMainDeploymentProcessor;
import org.craftercms.deployer.utils.BooleanUtils;
import org.craftercms.search.batch.BatchIndexer;
import org.craftercms.search.batch.UpdateSet;
import org.craftercms.search.batch.UpdateStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectFactory;

public abstract class AbstractSearchIndexingProcessor
extends AbstractMainDeploymentProcessor {
    private static final Logger logger = LoggerFactory.getLogger(AbstractSearchIndexingProcessor.class);
    protected static final String INDEX_ID_CONFIG_KEY = "indexId";
    protected static final String IGNORE_INDEX_ID_CONFIG_KEY = "ignoreIndexId";
    protected static final String REINDEX_ITEMS_ON_COMPONENT_UPDATES = "reindexItemsOnComponentUpdates";
    protected static final String CREATE_INDEX_IF_MISSING_CONFIG_KEY = "createIndexIfMissing";
    protected static final Pattern DEFAULT_DESCRIPTOR_PATH_PATTERN = Pattern.compile("^/site/.+\\.xml$");
    protected static final Pattern DEFAULT_COMPONENT_PATH_PATTERN = Pattern.compile("^/site/components/.+$");
    protected static final int DEFAULT_ITEMS_THAT_INCLUDE_COMPONENT_QUERY_ROWS = 100;
    protected CacheService cacheService;
    protected ObjectFactory<Context> contextFactory;
    protected ContentStoreService contentStoreService;
    protected List<BatchIndexer> batchIndexers;
    protected boolean xmlFlatteningEnabled;
    protected Pattern descriptorPathPattern = DEFAULT_DESCRIPTOR_PATH_PATTERN;
    protected Pattern componentPathPattern = DEFAULT_COMPONENT_PATH_PATTERN;
    protected int itemsThatIncludeComponentQueryRows = 100;
    protected String indexIdFormat;
    protected String indexId;
    protected boolean reindexItemsOnComponentUpdates;
    protected boolean createIndexIfMissing;

    public void setCacheService(CacheService cacheService) {
        this.cacheService = cacheService;
    }

    public void setContextFactory(ObjectFactory<Context> contextFactory) {
        this.contextFactory = contextFactory;
    }

    public void setContentStoreService(ContentStoreService contentStoreService) {
        this.contentStoreService = contentStoreService;
    }

    public void setBatchIndexer(BatchIndexer batchIndexer) {
        this.batchIndexers = Collections.singletonList(batchIndexer);
    }

    public void setBatchIndexers(List<BatchIndexer> batchIndexers) {
        this.batchIndexers = batchIndexers;
    }

    public void setXmlFlatteningEnabled(boolean xmlFlatteningEnabled) {
        this.xmlFlatteningEnabled = xmlFlatteningEnabled;
    }

    public void setDescriptorPathRegex(String descriptorPathRegex) {
        this.descriptorPathPattern = Pattern.compile(descriptorPathRegex);
    }

    public void setComponentPathRegex(String componentPathRegex) {
        this.componentPathPattern = Pattern.compile(componentPathRegex);
    }

    public void setItemsThatIncludeComponentQueryRows(int itemsThatIncludeComponentQueryRows) {
        this.itemsThatIncludeComponentQueryRows = itemsThatIncludeComponentQueryRows;
    }

    public void setIndexIdFormat(String indexIdFormat) {
        this.indexIdFormat = indexIdFormat;
    }

    protected void doInit(Configuration config) throws ConfigurationException {
        boolean ignoreIndexId = ConfigUtils.getBooleanProperty((Configuration)config, (String)IGNORE_INDEX_ID_CONFIG_KEY, (Boolean)false);
        if (ignoreIndexId) {
            this.indexId = null;
        } else {
            this.indexId = ConfigUtils.getStringProperty((Configuration)config, (String)INDEX_ID_CONFIG_KEY);
            if (StringUtils.isEmpty((CharSequence)this.indexId)) {
                this.indexId = String.format(this.indexIdFormat, this.siteName);
            }
        }
        this.reindexItemsOnComponentUpdates = ConfigUtils.getBooleanProperty((Configuration)config, (String)REINDEX_ITEMS_ON_COMPONENT_UPDATES, (Boolean)true);
        this.createIndexIfMissing = ConfigUtils.getBooleanProperty((Configuration)config, (String)CREATE_INDEX_IF_MISSING_CONFIG_KEY, (Boolean)true);
        if (CollectionUtils.isEmpty((Collection)this.batchIndexers)) {
            throw new IllegalStateException("At least one batch indexer should be provided");
        }
    }

    protected void doDestroy() throws DeployerException {
    }

    public boolean supportsMode(Deployment.Mode mode) {
        return mode == Deployment.Mode.PUBLISH || mode == Deployment.Mode.SEARCH_INDEX;
    }

    protected abstract void doCreateIndexIfMissing();

    protected ChangeSet expandChangeSet(ChangeSet changeSet) {
        if (this.createIndexIfMissing) {
            logger.info("Ensuring that index {} exists", (Object)this.indexId);
            this.doCreateIndexIfMissing();
        }
        boolean isReprocessAll = BooleanUtils.toBoolean((Object)this.getDeploymentParam("reprocess_all_files"));
        if (changeSet == null || changeSet.isEmpty() || !this.xmlFlatteningEnabled || isReprocessAll) {
            return changeSet;
        }
        List createdFiles = changeSet.getCreatedFiles();
        List updatedFiles = changeSet.getUpdatedFiles();
        List deletedFiles = changeSet.getDeletedFiles();
        ArrayList newUpdatedFiles = new ArrayList(updatedFiles);
        if (CollectionUtils.isNotEmpty((Collection)createdFiles)) {
            for (String path : createdFiles) {
                if (this.isDescriptor(path)) {
                    this.addItemsThatInheritFromDescriptorToUpdatedFiles(path, createdFiles, newUpdatedFiles, deletedFiles);
                }
                if (!this.reindexItemsOnComponentUpdates || !this.isComponent(path)) continue;
                this.addItemsThatIncludeComponentToUpdatedFiles(path, createdFiles, newUpdatedFiles, deletedFiles);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)updatedFiles)) {
            for (String path : updatedFiles) {
                if (this.isDescriptor(path)) {
                    this.addItemsThatInheritFromDescriptorToUpdatedFiles(path, createdFiles, newUpdatedFiles, deletedFiles);
                }
                if (!this.reindexItemsOnComponentUpdates || !this.isComponent(path)) continue;
                this.addItemsThatIncludeComponentToUpdatedFiles(path, createdFiles, newUpdatedFiles, deletedFiles);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)deletedFiles)) {
            for (String path : deletedFiles) {
                if (this.isDescriptor(path)) {
                    this.addItemsThatInheritFromDescriptorToUpdatedFiles(path, createdFiles, newUpdatedFiles, deletedFiles);
                }
                if (!this.reindexItemsOnComponentUpdates || !this.isComponent(path)) continue;
                this.addItemsThatIncludeComponentToUpdatedFiles(path, createdFiles, newUpdatedFiles, deletedFiles);
            }
        }
        ChangeSet filteredChangeSet = new ChangeSet(createdFiles, newUpdatedFiles, deletedFiles);
        filteredChangeSet.setUpdateDetails(changeSet.getUpdateDetails());
        filteredChangeSet.setUpdateLog(changeSet.getUpdateLog());
        return filteredChangeSet;
    }

    protected ChangeSet doMainProcess(Deployment deployment, ProcessorExecution execution, ChangeSet filteredChangeSet, ChangeSet originalChangeSet) throws DeployerException {
        logger.info("Performing search indexing...");
        ChangeSet expandedChangeSet = this.expandChangeSet(filteredChangeSet);
        List createdFiles = ListUtils.emptyIfNull((List)expandedChangeSet.getCreatedFiles());
        List updatedFiles = ListUtils.emptyIfNull((List)expandedChangeSet.getUpdatedFiles());
        List deletedFiles = ListUtils.emptyIfNull((List)expandedChangeSet.getDeletedFiles());
        UpdateSet updateSet = new UpdateSet(ListUtils.union((List)createdFiles, (List)updatedFiles), deletedFiles);
        updateSet.setUpdateDetails(expandedChangeSet.getUpdateDetails());
        updateSet.setUpdateLog(expandedChangeSet.getUpdateLog());
        UpdateStatus updateStatus = new UpdateStatus();
        execution.setStatusDetails((Object)updateStatus);
        Context context = (Context)this.contextFactory.getObject();
        logger.debug("Clearing cache for context {}", (Object)context);
        this.cacheService.clearScope(context);
        boolean failed = false;
        try {
            for (BatchIndexer indexer : this.batchIndexers) {
                indexer.updateIndex(this.indexId, this.siteName, this.contentStoreService, context, updateSet, updateStatus);
                if (updateStatus.getAttemptedUpdatesAndDeletes() > 0) {
                    this.doCommit(this.indexId);
                }
                failed = failed || updateStatus.getFailedUpdatesAndDeletes() > 0;
            }
        }
        catch (Exception e) {
            throw new DeployerException("Error while performing search indexing", (Throwable)e);
        }
        if (failed) {
            throw new DeployerException("Failed to update or delete some files, please check previous log messages for the causes of the failures");
        }
        return null;
    }

    protected abstract void doCommit(String var1);

    protected boolean isDescriptor(String path) {
        return this.descriptorPathPattern.matcher(path).matches();
    }

    protected boolean isComponent(String path) {
        return this.componentPathPattern.matcher(path).matches();
    }

    protected boolean isBeingUpdatedOrDeleted(String path, List<String> createdFiles, List<String> updatedFiles, List<String> deletedFiles) {
        return createdFiles.contains(path) || updatedFiles.contains(path) || deletedFiles.contains(path);
    }

    protected abstract List<String> getItemsThatInheritDescriptor(String var1, String var2);

    protected void addItemsThatInheritFromDescriptorToUpdatedFiles(String descriptorPath, List<String> createdFiles, List<String> updatedFiles, List<String> deletedFiles) {
        this.addAffectedItemsToUpdatedFiles(descriptorPath, createdFiles, updatedFiles, deletedFiles, (arg_0, arg_1) -> this.getItemsThatInheritDescriptor(arg_0, arg_1));
    }

    protected abstract List<String> getItemsThatIncludeComponent(String var1, String var2);

    protected void addItemsThatIncludeComponentToUpdatedFiles(String componentPath, List<String> createdFiles, List<String> updatedFiles, List<String> deletedFiles) {
        this.addAffectedItemsToUpdatedFiles(componentPath, createdFiles, updatedFiles, deletedFiles, (arg_0, arg_1) -> this.getItemsThatIncludeComponent(arg_0, arg_1));
    }

    protected void addAffectedItemsToUpdatedFiles(String path, List<String> createdFiles, List<String> updatedFiles, List<String> deletedFiles, BiFunction<String, String, List<String>> function) {
        List<String> itemPaths = function.apply(this.indexId, path);
        if (CollectionUtils.isNotEmpty(itemPaths)) {
            for (String itemPath : itemPaths) {
                if (this.isBeingUpdatedOrDeleted(itemPath, createdFiles, updatedFiles, deletedFiles)) continue;
                logger.debug("Item {} is affected by the update of {}. Adding it to list of updated files.", (Object)itemPath, (Object)path);
                updatedFiles.add(itemPath);
            }
        }
    }
}

