/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.deployer.impl.processors;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.io.FileUtils;
import org.craftercms.deployer.api.ChangeSet;
import org.craftercms.deployer.api.Deployment;
import org.craftercms.deployer.api.exceptions.DeployerException;
import org.craftercms.deployer.impl.processors.AbstractPostDeploymentProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileOutputProcessor
extends AbstractPostDeploymentProcessor {
    private static final Logger logger = LoggerFactory.getLogger(FileOutputProcessor.class);
    protected static final String[] HEADERS = new String[]{"mode", "status", "duration", "start", "end", "created_files", "updated_files", "deleted_files"};
    protected File outputFolder;

    public void setOutputFolder(File outputFolder) {
        this.outputFolder = outputFolder;
    }

    public void doInit(Configuration config) throws DeployerException {
        if (!this.outputFolder.exists()) {
            try {
                FileUtils.forceMkdir((File)this.outputFolder);
            }
            catch (IOException e) {
                throw new DeployerException("Failed to create output folder " + String.valueOf(this.outputFolder), (Throwable)e);
            }
        }
    }

    protected void doDestroy() {
    }

    public boolean supportsMode(Deployment.Mode mode) {
        return true;
    }

    protected ChangeSet doPostProcess(Deployment deployment, ChangeSet filteredChangeSet, ChangeSet originalChangeSet) throws DeployerException {
        File outputFile = this.getOutputFile(deployment);
        try (FileWriter fileWriter = new FileWriter(outputFile, true);){
            CSVPrinter filePrinter = outputFile.exists() && outputFile.length() > 0L ? new CSVPrinter((Appendable)fileWriter, CSVFormat.DEFAULT) : new CSVPrinter((Appendable)fileWriter, CSVFormat.Builder.create().setHeader(HEADERS).build());
            this.appendDeployment(filePrinter, deployment);
        }
        catch (IOException e) {
            throw new DeployerException("Error while writing deployment output file " + String.valueOf(outputFile), (Throwable)e);
        }
        logger.info("Successfully wrote deployment output to {}", (Object)outputFile);
        return null;
    }

    protected void appendDeployment(CSVPrinter printer, Deployment deployment) throws IOException {
        ChangeSet changeSet = deployment.getChangeSet();
        printer.printRecord(new Object[]{deployment.getStatus(), deployment.getDuration(), deployment.getStart().toInstant(), deployment.getEnd().toInstant(), ListUtils.emptyIfNull((List)changeSet.getCreatedFiles()), ListUtils.emptyIfNull((List)changeSet.getUpdatedFiles()), ListUtils.emptyIfNull((List)changeSet.getDeletedFiles())});
    }

    protected File getOutputFile(Deployment deployment) {
        String targetId = deployment.getTarget().getId();
        String outputFilename = targetId + "-deployments.csv";
        return new File(this.outputFolder, outputFilename);
    }
}

