/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.deployer.impl.processors;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpTrace;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.craftercms.commons.config.ConfigUtils;
import org.craftercms.commons.config.ConfigurationException;
import org.craftercms.deployer.api.ChangeSet;
import org.craftercms.deployer.api.Deployment;
import org.craftercms.deployer.api.ProcessorExecution;
import org.craftercms.deployer.api.exceptions.DeployerException;
import org.craftercms.deployer.impl.processors.AbstractMainDeploymentProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpMethodCallProcessor
extends AbstractMainDeploymentProcessor {
    private static final Logger logger = LoggerFactory.getLogger(HttpMethodCallProcessor.class);
    protected static final String URL_CONFIG_KEY = "url";
    protected static final String METHOD_CONFIG_KEY = "method";
    protected String url;
    protected String method;
    protected CloseableHttpClient httpClient;

    protected void doInit(Configuration config) throws ConfigurationException {
        this.url = ConfigUtils.getRequiredStringProperty((Configuration)config, (String)URL_CONFIG_KEY);
        this.method = ConfigUtils.getRequiredStringProperty((Configuration)config, (String)METHOD_CONFIG_KEY);
        this.httpClient = HttpClients.createDefault();
    }

    protected void doDestroy() {
    }

    protected ChangeSet doMainProcess(Deployment deployment, ProcessorExecution execution, ChangeSet filteredChangeSet, ChangeSet originalChangeSet) throws DeployerException {
        HttpUriRequest request = this.createRequest();
        URI uri = request.getURI();
        String safeURI = "";
        try {
            safeURI = new URI(uri.getScheme(), null, uri.getHost(), uri.getPort(), uri.getPath(), null, uri.getFragment()).toString();
        }
        catch (URISyntaxException e) {
            logger.error("Error parsing URI", (Throwable)e);
        }
        String safeRequest = String.join((CharSequence)" ", request.getMethod(), safeURI);
        logger.info("Executing request {}...", (Object)safeRequest);
        try (CloseableHttpResponse response = this.httpClient.execute(request);){
            String body;
            int status = response.getStatusLine().getStatusCode();
            HttpEntity entity = response.getEntity();
            String string = body = entity != null ? EntityUtils.toString((HttpEntity)entity) : null;
            if (StringUtils.isEmpty((CharSequence)body)) {
                body = "empty";
            }
            if (status >= 200 && status < 300) {
                logger.info("Successful response for request {}: status = {}, body = {}", new Object[]{safeRequest, status, body});
                execution.setStatusDetails((Object)("Successful response for request " + safeRequest + ": status = " + status));
            } else {
                logger.error("Error response for request {}: status = {}, body = {}", new Object[]{safeRequest, status, body});
                execution.setStatusDetails((Object)("Error response for request " + safeRequest + ": status = " + status));
                execution.endExecution(Deployment.Status.FAILURE);
            }
        }
        catch (IOException e) {
            throw new DeployerException("IO error on HTTP request " + safeRequest, (Throwable)e);
        }
        return null;
    }

    protected HttpUriRequest createRequest() throws DeployerException {
        if (this.method.equalsIgnoreCase("get")) {
            return new HttpGet(this.url);
        }
        if (this.method.equalsIgnoreCase("post")) {
            return new HttpPost(this.url);
        }
        if (this.method.equalsIgnoreCase("put")) {
            return new HttpPut(this.url);
        }
        if (this.method.equalsIgnoreCase("delete")) {
            return new HttpDelete(this.url);
        }
        if (this.method.equalsIgnoreCase("head")) {
            return new HttpHead(this.url);
        }
        if (this.method.equalsIgnoreCase("options")) {
            return new HttpOptions(this.url);
        }
        if (this.method.equalsIgnoreCase("trace")) {
            return new HttpTrace(this.url);
        }
        throw new DeployerException("HTTP method '" + this.method + " not recognized");
    }
}

