/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.deployer.impl.processors.notification;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.commons.config.ConfigUtils;
import org.craftercms.commons.config.ConfigurationException;
import org.craftercms.commons.notification.NotificationSender;
import org.craftercms.deployer.api.ChangeSet;
import org.craftercms.deployer.api.Deployment;
import org.craftercms.deployer.api.ProcessorExecution;
import org.craftercms.deployer.api.exceptions.DeployerException;
import org.craftercms.deployer.impl.ProcessorStateStore;
import org.craftercms.deployer.impl.processors.AbstractPostDeploymentProcessor;
import org.craftercms.deployer.impl.processors.notification.NotificationProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class NotificationProcessor
extends AbstractPostDeploymentProcessor {
    private static final Logger logger = LoggerFactory.getLogger(NotificationProcessor.class);
    public static final String PROCESSOR_MATCH_PATTERNS_CONFIG_KEY = "failedProcessors";
    public static final String MUTE_PERIOD_MINUTES_CONFIG_KEY = "mutePeriodMinutes";
    public static final String LAST_DATETIME_FILE_SUFFIX_CONFIG_KEY = "lastDateFilenameSuffix";
    public static final String STATUS_CONDITION_CONFIG_KEY = "status";
    public static final String SERVER_NAME_CONFIG_KEY = "serverName";
    public static final String TEMPLATE_NAME_CONFIG_KEY = "templateName";
    public static final String DATETIME_PATTERN_CONFIG_KEY = "dateTimePattern";
    public static final String SERVER_NAME_MODEL_KEY = "serverName";
    public static final String TARGET_ID_MODEL_KEY = "targetId";
    public static final String START_MODEL_KEY = "start";
    public static final String END_MODEL_KEY = "end";
    public static final String STATUS_MODEL_KEY = "status";
    public static final String DEPLOYMENT_MODEL_KEY = "deployment";
    private String defaultStatusCondition;
    private String defaultLastDateFilenameSuffix;
    private String defaultTemplateName;
    private String defaultDateTimePattern;
    private ProcessorStateStore processorStateStore;
    protected NotificationSender<?> notificationSender;
    protected String templateName;
    protected String serverName;
    protected StatusCondition statusCondition;
    protected Pattern failedProcessorsPattern;
    protected int mutePeriodMinutes;
    private String lastDateFilenameSuffix;
    protected DateTimeFormatter dateTimeFormatter;

    public void doInit(Configuration config) throws ConfigurationException, DeployerException {
        this.statusCondition = StatusCondition.valueOf((String)ConfigUtils.getStringProperty((Configuration)config, (String)"status", (String)this.defaultStatusCondition));
        String processorsMatchRegex = ConfigUtils.getStringProperty((Configuration)config, (String)"failedProcessors");
        if (processorsMatchRegex != null) {
            this.failedProcessorsPattern = Pattern.compile(processorsMatchRegex);
        }
        this.mutePeriodMinutes = ConfigUtils.getIntegerProperty((Configuration)config, (String)"mutePeriodMinutes", (Integer)0);
        this.lastDateFilenameSuffix = ConfigUtils.getStringProperty((Configuration)config, (String)"lastDateFilenameSuffix", (String)this.defaultLastDateFilenameSuffix);
        this.templateName = ConfigUtils.getStringProperty((Configuration)config, (String)"templateName", (String)this.defaultTemplateName);
        this.serverName = ConfigUtils.getStringProperty((Configuration)config, (String)"serverName");
        if (StringUtils.isEmpty((CharSequence)this.serverName)) {
            try {
                this.serverName = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                throw new DeployerException("Unable to retrieve localhost address", (Throwable)e);
            }
        }
        String dateTimePattern = ConfigUtils.getStringProperty((Configuration)config, (String)"dateTimePattern", (String)this.defaultDateTimePattern);
        this.dateTimeFormatter = DateTimeFormatter.ofPattern(dateTimePattern);
        this.notificationSender.init(config);
    }

    protected void doDestroy() {
        try {
            this.notificationSender.close();
        }
        catch (Exception e) {
            logger.error("Error while closing notification sender", (Throwable)e);
        }
    }

    private boolean matchesStatusCondition(Deployment deployment) {
        Deployment.Status status = deployment.getStatus();
        return switch (this.statusCondition.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                if (status == Deployment.Status.SUCCESS) {
                    yield true;
                }
                yield false;
            }
            case 1 -> true;
            case 2 -> {
                if (status == Deployment.Status.FAILURE || this.hasExecutionsFailures(deployment)) {
                    yield true;
                }
                yield false;
            }
            case 3 -> status == Deployment.Status.FAILURE;
        };
    }

    protected ChangeSet doPostProcess(Deployment deployment, ChangeSet filteredChangeSet, ChangeSet originalChangeSet) throws DeployerException {
        Deployment.Status status = deployment.getStatus();
        if (!this.matchesStatusCondition(deployment)) {
            logger.info("Skipping notification because status '{}' does not match the condition '{}'", (Object)status, (Object)this.statusCondition);
            return null;
        }
        String failedProcessor = this.getFailedProcessor(deployment);
        if (!this.matchFailedProcessor(failedProcessor)) {
            logger.info("Skipping notification because failed processors do not match the configured patterns");
            return null;
        }
        if (this.mutePeriodRunning(failedProcessor)) {
            logger.info("Skipping notification because the mute period has not expired");
            return null;
        }
        try {
            this.notificationSender.sendMessage(this.templateName, (Object)deployment, this.getModel(deployment));
        }
        catch (Exception e) {
            throw new DeployerException("Failed to send notification for deployment", (Throwable)e);
        }
        this.storeNotificationDate(failedProcessor);
        return null;
    }

    private void storeNotificationDate(String processor) {
        if (processor == null) {
            return;
        }
        if (this.mutePeriodMinutes <= 0) {
            return;
        }
        try {
            this.processorStateStore.store(this.targetId, this.name, this.getStateFileSuffix(processor), String.valueOf(System.currentTimeMillis()));
        }
        catch (IOException e) {
            logger.warn("Could not store last notification date", (Throwable)e);
        }
    }

    private String getStateFileSuffix(String processor) {
        return "%s%s".formatted(processor, this.lastDateFilenameSuffix);
    }

    private boolean mutePeriodRunning(String processor) {
        if (processor == null) {
            logger.info("Mute period does not apply for successful deployments, sending notification");
            return false;
        }
        if (this.mutePeriodMinutes <= 0) {
            logger.info("Mute period is 0 or negative, sending notification");
            return false;
        }
        try {
            String lastNotificationTimestamp = this.processorStateStore.load(this.targetId, this.name, this.getStateFileSuffix(processor));
            if (lastNotificationTimestamp == null) {
                logger.info("No last notification date found, sending notification");
                return false;
            }
            long lastNotificationMillis = Long.parseLong(lastNotificationTimestamp);
            long mutePeriodMillis = (long)(this.mutePeriodMinutes * 60) * 1000L;
            if (System.currentTimeMillis() - lastNotificationMillis < mutePeriodMillis) {
                logger.info("Mute period has not expired, skipping notification");
                return true;
            }
        }
        catch (NumberFormatException e) {
            logger.error("Could not parse last notification date", (Throwable)e);
        }
        catch (IOException e) {
            logger.error("Could not read last notification date from store", (Throwable)e);
        }
        return false;
    }

    protected Map<String, Object> getModel(Deployment deployment) {
        HashMap<String, Object> templateModel = new HashMap<String, Object>();
        templateModel.put("serverName", this.serverName);
        templateModel.put("targetId", deployment.getTarget().getId());
        templateModel.put("start", deployment.getStart().format(this.dateTimeFormatter));
        templateModel.put("end", deployment.getEnd().format(this.dateTimeFormatter));
        templateModel.put("status", deployment.getStatus());
        templateModel.put("deployment", deployment);
        return templateModel;
    }

    private boolean matchFailedProcessor(String failedProcessor) {
        return this.failedProcessorsPattern == null || this.failedProcessorsPattern.matcher(failedProcessor).matches();
    }

    private String getFailedProcessor(Deployment deployment) {
        return deployment.getProcessorExecutions().stream().filter(ex -> ex.getStatus() == Deployment.Status.FAILURE).map(ProcessorExecution::getProcessorName).findFirst().orElse(null);
    }

    private boolean hasExecutionsFailures(Deployment deployment) {
        for (ProcessorExecution execution : deployment.getProcessorExecutions()) {
            if (execution.getStatus() != Deployment.Status.FAILURE) continue;
            return true;
        }
        return false;
    }

    public void setDefaultDateTimePattern(String defaultDateTimePattern) {
        this.defaultDateTimePattern = defaultDateTimePattern;
    }

    public void setDefaultLastDateFilenameSuffix(String defaultLastDateFilenameSuffix) {
        this.defaultLastDateFilenameSuffix = defaultLastDateFilenameSuffix;
    }

    public void setDefaultStatusCondition(String defaultStatusCondition) {
        this.defaultStatusCondition = defaultStatusCondition;
    }

    public void setDefaultTemplateName(String defaultTemplateName) {
        this.defaultTemplateName = defaultTemplateName;
    }

    public void setProcessorStateStore(ProcessorStateStore processorStateStore) {
        this.processorStateStore = processorStateStore;
    }

    public void setNotificationSender(NotificationSender<?> notificationSender) {
        this.notificationSender = notificationSender;
    }
}

