/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.deployer.impl.target.event;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.commons.config.ConfigUtils;
import org.craftercms.commons.config.ConfigurationException;
import org.craftercms.commons.notification.NotificationSender;
import org.craftercms.deployer.api.Target;
import org.craftercms.deployer.api.exceptions.DeployerException;
import org.craftercms.deployer.api.target.event.TargetEvent;
import org.craftercms.deployer.api.target.event.TargetEventListener;
import org.springframework.context.ApplicationContext;

public class NotificationEventListener
implements TargetEventListener {
    public static final String EVENT_MODEL_KEY = "event";
    public static final String TARGET_MODEL_KEY = "target";
    private NotificationSender<?> notificationSender;
    protected String templateName;
    protected String serverName;

    public void init(Configuration config, ApplicationContext applicationContext) throws ConfigurationException, DeployerException {
        this.templateName = ConfigUtils.getRequiredStringProperty((Configuration)config, (String)"templateName");
        if (StringUtils.isEmpty((CharSequence)this.templateName)) {
            throw new ConfigurationException("The 'templateName' property is required for NotificationEventListener");
        }
        this.serverName = ConfigUtils.getStringProperty((Configuration)config, (String)"serverName");
        if (StringUtils.isEmpty((CharSequence)this.serverName)) {
            try {
                this.serverName = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                throw new DeployerException("Unable to retrieve localhost address", (Throwable)e);
            }
        }
        String senderName = ConfigUtils.getRequiredStringProperty((Configuration)config, (String)"sender");
        this.notificationSender = (NotificationSender)applicationContext.getBean(senderName, NotificationSender.class);
        this.notificationSender.init(config);
    }

    public void handle(TargetEvent<?> event) throws DeployerException {
        Map<String, Target> model = Map.of(EVENT_MODEL_KEY, event, TARGET_MODEL_KEY, event.target());
        try {
            this.notificationSender.sendMessage(this.templateName, event.payload(), model);
        }
        catch (Exception e) {
            throw new DeployerException("Error sending notification for event: " + String.valueOf(event), (Throwable)e);
        }
    }
}

