/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.deployer.impl.tasks;

import java.beans.ConstructorProperties;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import org.craftercms.deployer.api.Deployment;
import org.craftercms.deployer.api.Target;
import org.craftercms.deployer.api.TargetService;
import org.craftercms.deployer.api.exceptions.TargetServiceException;
import org.craftercms.deployer.api.target.event.TargetEvent;
import org.craftercms.deployer.impl.target.event.DeploymentRuntimeWarningEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(value={"deployer.main.deployments.supervisor.enabled"})
public class TargetDeploymentRuntimeSupervisor {
    private static final Logger logger = LoggerFactory.getLogger(TargetDeploymentRuntimeSupervisor.class);
    protected final TargetService targetService;

    @ConstructorProperties(value={"targetService"})
    public TargetDeploymentRuntimeSupervisor(TargetService targetService) {
        this.targetService = targetService;
    }

    @Scheduled(cron="${deployer.main.deployments.supervisor.cron}")
    public void checkDeploymentsRuntime() throws TargetServiceException {
        logger.info("Checking deployments runtime");
        this.targetService.getAllTargets().forEach(target -> {
            try {
                this.checkDeploymentRuntime(target);
            }
            catch (Exception e) {
                logger.error("Failed to check deployment runtime for target: {}", (Object)target.getId(), (Object)e);
            }
        });
        logger.info("Completed checking deployments runtime");
    }

    protected void checkDeploymentRuntime(Target target) {
        long runtimeThreshold;
        ZonedDateTime now;
        logger.trace("Checking deployment runtime for target: {}", (Object)target.getId());
        Deployment currentDeployment = target.getCurrentDeployment();
        if (currentDeployment == null || !currentDeployment.isRunning()) {
            logger.debug("No running deployment found for target: {}", (Object)target.getId());
            return;
        }
        ZonedDateTime start = currentDeployment.getStart();
        long runtime = start.until(now = ZonedDateTime.now(), ChronoUnit.SECONDS);
        if (runtime >= (runtimeThreshold = target.getRuntimeWarningThreshold())) {
            long runtimeMillis = start.until(now, ChronoUnit.MILLIS);
            logger.error("Deployment for target {} has been running for {} seconds, which reaches the threshold of {} seconds", new Object[]{target.getId(), runtime, runtimeThreshold});
            target.handleEvent((TargetEvent)new DeploymentRuntimeWarningEvent(target, currentDeployment, runtimeMillis));
        } else {
            logger.debug("Deployment for target {} is running within the acceptable threshold of {} seconds", (Object)target.getId(), (Object)runtimeThreshold);
        }
        logger.trace("Target: {}, Deployment start: {}, Now: {}, Runtime: {} seconds, Threshold: {} seconds", new Object[]{target.getId(), start, now, runtime, runtimeThreshold});
    }
}

