/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.deployer.impl.upgrade.operations;

import java.io.BufferedWriter;
import java.io.InputStream;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import org.craftercms.commons.config.DisableClassLoadingConstructor;
import org.craftercms.commons.upgrade.impl.UpgradeContext;
import org.craftercms.commons.upgrade.impl.operations.AbstractUpgradeOperation;
import org.craftercms.deployer.api.Target;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.representer.Representer;

public abstract class AbstractTargetUpgradeOperation
extends AbstractUpgradeOperation<Target> {
    public static final String CONFIG_KEY_PROCESSOR = "processor";
    public static final String CONFIG_KEY_REPLACE = "replace";
    public static final String CONFIG_KEY_REMOVE = "remove";
    public static final String CONFIG_KEY_PROPERTIES = "properties";
    public static final String CONFIG_KEY_PROPERTY = "property";
    public static final String CONFIG_KEY_PATTERN = "pattern";
    public static final String CONFIG_KEY_EXPRESSION = "expression";
    public static final String CONFIG_KEY_ADD = "add";
    public static final String CONFIG_KEY_VALUE = "value";
    public static final String CONFIG_KEY_VALUES = "values";
    public static final String CONFIG_KEY_TARGET = "target";
    public static final String CONFIG_KEY_DEPLOYMENT = "deployment";
    public static final String CONFIG_KEY_PIPELINE = "pipeline";
    public static final String CONFIG_KEY_PROCESSOR_NAME = "processorName";
    public static final String CONFIG_KEY_LIFECYCLE_HOOKS = "lifecycleHooks";
    public static final String CONFIG_KEY_HOOK_NAME = "hookName";
    protected Yaml yaml;

    public AbstractTargetUpgradeOperation() {
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        options.setPrettyFlow(true);
        this.yaml = new Yaml((BaseConstructor)new DisableClassLoadingConstructor(new LoaderOptions()), new Representer(options), options);
    }

    protected List<Map<String, Object>> getPipeline(Map<String, Object> targetConfig) {
        Map targetObj = (Map)targetConfig.get(CONFIG_KEY_TARGET);
        Map deploymentObj = (Map)targetObj.get(CONFIG_KEY_DEPLOYMENT);
        return (List)deploymentObj.get(CONFIG_KEY_PIPELINE);
    }

    protected void doExecute(UpgradeContext<Target> context) throws Exception {
        Map targetConfig;
        Target target = (Target)context.getTarget();
        Path file = target.getConfigurationFile().toPath();
        this.logger.debug("Loading target configuration for {}", (Object)target.getId());
        try (InputStream is = Files.newInputStream(file, new OpenOption[0]);){
            targetConfig = (Map)this.yaml.load(is);
        }
        this.doExecute(target, targetConfig);
        this.logger.debug("Writing target configuration for {}", (Object)target.getId());
        try (BufferedWriter writer = Files.newBufferedWriter(file, new OpenOption[0]);){
            this.yaml.dump((Object)targetConfig, (Writer)writer);
        }
    }

    protected abstract void doExecute(Target var1, Map<String, Object> var2) throws Exception;
}

