/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.deployer.impl.upgrade.operations;

import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.craftercms.commons.config.ConfigUtils;
import org.craftercms.commons.upgrade.impl.UpgradeContext;
import org.craftercms.commons.upgrade.impl.operations.AbstractUpgradeOperation;
import org.craftercms.deployer.api.Target;
import org.craftercms.search.opensearch.OpenSearchAdminService;

public class ElasticsearchIndexUpgradeOperation
extends AbstractUpgradeOperation<Target> {
    protected static final String PROCESSOR_NAME_PATTERN = "(authoringE|e)lasticsearchIndexingProcessor";

    protected boolean containsProcessor(HierarchicalConfiguration<?> config) {
        return config.configurationsAt("target.deployment.pipeline").stream().anyMatch(processor -> processor.getString("processorName").matches(PROCESSOR_NAME_PATTERN));
    }

    protected void doExecute(UpgradeContext<Target> context) throws Exception {
        Target target = (Target)context.getTarget();
        HierarchicalConfiguration config = target.getConfiguration();
        OpenSearchAdminService adminService = (OpenSearchAdminService)target.getApplicationContext().getBean(OpenSearchAdminService.class);
        String siteName = target.getSiteName();
        String indexIdFormat = ConfigUtils.getRequiredStringProperty((Configuration)config, (String)"target.search.indexIdFormat");
        String aliasName = String.format(indexIdFormat, siteName);
        adminService.waitUntilReady();
        adminService.recreateIndex(aliasName);
    }
}

