/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.deployer.impl.upgrade.operations;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.craftercms.commons.crypto.TextEncryptor;
import org.craftercms.commons.upgrade.impl.UpgradeContext;
import org.craftercms.commons.upgrade.impl.operations.AbstractUpgradeOperation;
import org.craftercms.deployer.api.Target;

public class EncryptionUpgradeOperation
extends AbstractUpgradeOperation<Target> {
    protected static String DEFAULT_ENCRYPTED_PATTERN = "\\$\\{enc:([^}#]+)}";
    protected Pattern encryptedPattern = Pattern.compile(DEFAULT_ENCRYPTED_PATTERN);
    protected TextEncryptor textEncryptor;

    public EncryptionUpgradeOperation(TextEncryptor textEncryptor) {
        this.textEncryptor = textEncryptor;
    }

    protected void doExecute(UpgradeContext<Target> context) throws Exception {
        String content;
        File file = ((Target)context.getTarget()).getConfigurationFile();
        try (FileReader reader = new FileReader(file);){
            content = IOUtils.toString((Reader)reader);
        }
        Matcher matcher = this.encryptedPattern.matcher(content);
        boolean updateFile = matcher.matches();
        while (matcher.find()) {
            String encryptedValue = matcher.group(1);
            String originalValue = this.textEncryptor.decrypt(encryptedValue);
            String newValue = this.textEncryptor.encrypt(originalValue);
            content = content.replaceAll(encryptedValue, newValue);
            updateFile = true;
        }
        if (updateFile) {
            try (FileWriter writer = new FileWriter(file);){
                IOUtils.write((String)content, (Writer)writer);
            }
        }
    }
}

