/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.deployer.utils.aws;

import org.apache.commons.configuration2.Configuration;
import org.craftercms.commons.config.ConfigUtils;
import org.craftercms.commons.config.ConfigurationException;
import org.craftercms.deployer.utils.aws.AwsClientBuilderConfigurer;
import software.amazon.awssdk.awscore.client.builder.AwsClientBuilder;
import software.amazon.awssdk.services.s3.S3BaseClientBuilder;
import software.amazon.awssdk.services.s3.S3Configuration;

public class AwsS3ClientBuilderConfigurer
extends AwsClientBuilderConfigurer<S3BaseClientBuilder> {
    public static final String CONFIG_KEY_PATH_STYLE_ACCESS_ENABLED = "pathStyleAccess";
    protected boolean pathStyleAccessEnabled = false;

    public AwsS3ClientBuilderConfigurer(Configuration config) throws ConfigurationException {
        super(config);
        if (config.containsKey(CONFIG_KEY_PATH_STYLE_ACCESS_ENABLED)) {
            this.pathStyleAccessEnabled = ConfigUtils.getBooleanProperty((Configuration)config, (String)CONFIG_KEY_PATH_STYLE_ACCESS_ENABLED);
        }
    }

    public void configureClientBuilder(S3BaseClientBuilder builder) {
        super.configureClientBuilder((AwsClientBuilder)builder);
        if (this.pathStyleAccessEnabled) {
            builder.serviceConfiguration((S3Configuration)S3Configuration.builder().pathStyleAccessEnabled(Boolean.valueOf(true)).build());
        }
    }
}

