/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.deployer.utils.opensearch;

import java.net.URISyntaxException;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.craftercms.commons.config.ConfigurationException;
import org.craftercms.search.opensearch.spring.OpenSearchClientFactory;
import org.opensearch.client.opensearch.OpenSearchClient;

public class OpenSearchClusterConfig {
    public static final String CONFIG_KEY_URLS = "urls";
    public static final String CONFIG_KEY_USERNAME = "username";
    public static final String CONFIG_KEY_PASSWORD = "password";
    public static final String CONFIG_KEY_TIMEOUT_CONNECT = "timeout.connect";
    public static final String CONFIG_KEY_TIMEOUT_SOCKET = "timeout.socket";
    public static final String CONFIG_KEY_THREADS = "threads";
    public static final String CONFIG_KEY_KEEP_ALIVE = "keepAlive";
    public static final String CONFIG_KEY_MAX_TOTAL_CONNECTIONS = "maxTotalConnections";
    public static final String CONFIG_KEY_MAX_CONNECTIONS_PER_ROUTE = "maxConnectionsPerRoute";
    public final String[] urls;
    public final String username;
    public final String password;
    public final int connectTimeout;
    public final int socketTimeout;
    public final int threadCount;
    public final boolean keepAlive;
    public final int maxTotalConnections;
    public final int maxConnectionsPerRoute;

    public OpenSearchClusterConfig() {
        this.urls = null;
        this.username = null;
        this.password = null;
        this.connectTimeout = -1;
        this.socketTimeout = -1;
        this.threadCount = -1;
        this.keepAlive = false;
        this.maxTotalConnections = -1;
        this.maxConnectionsPerRoute = -1;
    }

    public OpenSearchClusterConfig(HierarchicalConfiguration<?> config) {
        this.urls = (String[])config.getArray(String.class, CONFIG_KEY_URLS);
        this.username = config.getString(CONFIG_KEY_USERNAME, null);
        this.password = config.getString(CONFIG_KEY_PASSWORD, null);
        this.connectTimeout = config.getInt(CONFIG_KEY_TIMEOUT_CONNECT, -1);
        this.socketTimeout = config.getInt(CONFIG_KEY_TIMEOUT_SOCKET, -1);
        this.threadCount = config.getInt(CONFIG_KEY_THREADS, -1);
        this.keepAlive = config.getBoolean(CONFIG_KEY_KEEP_ALIVE, false);
        this.maxTotalConnections = config.getInt(CONFIG_KEY_MAX_TOTAL_CONNECTIONS, -1);
        this.maxConnectionsPerRoute = config.getInt(CONFIG_KEY_MAX_CONNECTIONS_PER_ROUTE, -1);
    }

    public OpenSearchClusterConfig(HierarchicalConfiguration<?> config, String username, String password, int connectTimeout, int socketTimeout, int threadCount, boolean keepAlive, int maxTotalConnections, int maxConnectionsPerRoute) {
        this.urls = (String[])config.getArray(String.class, CONFIG_KEY_URLS);
        this.username = config.getString(CONFIG_KEY_USERNAME, username);
        this.password = config.getString(CONFIG_KEY_PASSWORD, password);
        this.connectTimeout = config.getInt(CONFIG_KEY_TIMEOUT_CONNECT, connectTimeout);
        this.socketTimeout = config.getInt(CONFIG_KEY_TIMEOUT_SOCKET, socketTimeout);
        this.threadCount = config.getInt(CONFIG_KEY_THREADS, threadCount);
        this.keepAlive = config.getBoolean(CONFIG_KEY_KEEP_ALIVE, keepAlive);
        this.maxTotalConnections = config.getInt(CONFIG_KEY_MAX_TOTAL_CONNECTIONS, maxTotalConnections);
        this.maxConnectionsPerRoute = config.getInt(CONFIG_KEY_MAX_CONNECTIONS_PER_ROUTE, maxConnectionsPerRoute);
    }

    public OpenSearchClient buildClient() throws ConfigurationException {
        try {
            return OpenSearchClientFactory.createClient((String[])this.urls, (String)this.username, (String)this.password, (int)this.connectTimeout, (int)this.socketTimeout, (int)this.threadCount, (boolean)this.keepAlive, (int)this.maxTotalConnections, (int)this.maxConnectionsPerRoute);
        }
        catch (URISyntaxException e) {
            throw new ConfigurationException("Error building OpenSearch client. Invalid url", (Throwable)e);
        }
    }
}

