/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.deployer.utils.opensearch.legacy;

import java.util.ArrayList;
import org.craftercms.commons.config.ConfigurationException;
import org.craftercms.deployer.utils.opensearch.legacy.OpenSearchClusterConfig;
import org.craftercms.deployer.utils.opensearch.legacy.OpenSearchConfig;
import org.opensearch.client.RestHighLevelClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.config.AbstractFactoryBean;

public abstract class AbstractOpenSearchFactory<T extends AutoCloseable>
extends AbstractFactoryBean<T>
implements BeanNameAware {
    private static final Logger logger = LoggerFactory.getLogger(AbstractOpenSearchFactory.class);
    protected String name;
    protected OpenSearchConfig config;

    public AbstractOpenSearchFactory(OpenSearchConfig config) {
        this.config = config;
    }

    public void setBeanName(String name) {
        this.name = name;
    }

    protected T createInstance() throws ConfigurationException {
        logger.debug("Creating instance for '{}'", (Object)this.name);
        if (this.config.useSingleCluster()) {
            logger.debug("Using a single cluster configuration for '{}'", (Object)this.name);
            return (T)this.doCreateSingleInstance(this.config.globalCluster.buildClient());
        }
        logger.debug("Using a multi-cluster configuration for '{}'", (Object)this.name);
        ArrayList<RestHighLevelClient> writeClientList = new ArrayList<RestHighLevelClient>(this.config.writeClusters.size());
        try {
            for (OpenSearchClusterConfig writeCluster : this.config.writeClusters) {
                writeClientList.add(writeCluster.buildClient());
            }
            RestHighLevelClient readClient = this.config.readCluster.buildClient();
            return (T)this.doCreateMultiInstance(readClient, writeClientList.toArray(new RestHighLevelClient[0]));
        }
        catch (ConfigurationException e) {
            this.closeClients(writeClientList);
            throw e;
        }
    }

    private void closeClients(ArrayList<RestHighLevelClient> writeClientList) {
        for (RestHighLevelClient client : writeClientList) {
            try {
                client.close();
            }
            catch (Exception ex) {
                logger.warn("Could not close OpenSearch client for '{}'", (Object)this.name, (Object)ex);
            }
        }
    }

    protected abstract T doCreateSingleInstance(RestHighLevelClient var1);

    protected abstract T doCreateMultiInstance(RestHighLevelClient var1, RestHighLevelClient[] var2);

    protected void destroyInstance(T instance) throws Exception {
        logger.debug("Closing all clients for '{}'", (Object)this.name);
        instance.close();
    }
}

