/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.deployer.utils.scripting;

import groovy.lang.GroovyClassLoader;
import groovy.util.GroovyScriptEngine;
import java.beans.ConstructorProperties;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;
import org.jenkinsci.plugins.scriptsecurity.sandbox.groovy.RejectASTTransformsCustomizer;
import org.kohsuke.groovy.sandbox.SandboxTransformer;
import org.springframework.beans.factory.config.AbstractFactoryBean;

public class ScriptEngineFactory
extends AbstractFactoryBean<GroovyScriptEngine> {
    protected String[] urls;
    protected boolean sandboxEnabled;

    @ConstructorProperties(value={"urls", "sandboxEnabled"})
    public ScriptEngineFactory(String[] urls, boolean sandboxEnabled) {
        this.urls = urls;
        this.sandboxEnabled = sandboxEnabled;
    }

    public Class<?> getObjectType() {
        return GroovyScriptEngine.class;
    }

    protected GroovyScriptEngine createInstance() throws Exception {
        CompilerConfiguration compilerConfig = new CompilerConfiguration();
        if (this.sandboxEnabled) {
            compilerConfig.addCompilationCustomizers(new CompilationCustomizer[]{new RejectASTTransformsCustomizer(), new SandboxTransformer()});
        }
        return new GroovyScriptEngine(this.urls, (ClassLoader)new GroovyClassLoader(this.getClass().getClassLoader(), compilerConfig));
    }
}

