/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.flowframework.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import jakarta.json.bind.Jsonb;
import jakarta.json.bind.JsonbBuilder;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessageFactory;
import org.apache.lucene.search.join.ScoreMode;
import org.opensearch.action.get.GetResponse;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.Booleans;
import org.opensearch.common.io.Streams;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.common.xcontent.json.JsonXContent;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.action.ActionResponse;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.flowframework.exception.FlowFrameworkException;
import org.opensearch.flowframework.indices.FlowFrameworkIndicesHandler;
import org.opensearch.flowframework.model.Template;
import org.opensearch.flowframework.model.WorkflowState;
import org.opensearch.flowframework.util.RestHandlerUtils;
import org.opensearch.flowframework.util.TenantAwareHelper;
import org.opensearch.flowframework.workflow.WorkflowData;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.NestedQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.index.query.TermsQueryBuilder;
import org.opensearch.ml.repackage.com.google.common.collect.ImmutableList;
import org.opensearch.remote.metadata.client.GetDataObjectRequest;
import org.opensearch.remote.metadata.client.SdkClient;
import org.opensearch.remote.metadata.common.SdkClientUtils;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.transport.client.Client;

public class ParseUtils {
    private static final Logger logger = LogManager.getLogger(ParseUtils.class);
    private static final Pattern SUBSTITUTION_PATTERN = Pattern.compile("\\$\\{\\{\\s*([\\w_]+)\\.([\\w_]+)\\s*\\}\\}");
    private static final Pattern JSON_ARRAY_DOUBLE_QUOTES_PATTERN = Pattern.compile("\"\\[(.*?)]\"");

    private ParseUtils() {
    }

    public static XContentParser jsonToParser(String json) throws IOException {
        XContentParser parser = JsonXContent.jsonXContent.createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, json);
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
        return parser;
    }

    public static String resourceToString(String path) throws IOException {
        try (InputStream is = ParseUtils.class.getResourceAsStream(path);){
            if (is == null) {
                throw new FileNotFoundException("Resource [" + path + "] not found in classpath");
            }
            StringBuilder sb = new StringBuilder();
            Streams.readAllLines((InputStream)is, sb::append);
            String string = sb.toString();
            return string;
        }
    }

    public static void buildStringToStringMap(XContentBuilder xContentBuilder, Map<?, ?> map) throws IOException {
        xContentBuilder.startObject();
        for (Map.Entry<?, ?> e : map.entrySet()) {
            xContentBuilder.field((String)e.getKey(), (String)e.getValue());
        }
        xContentBuilder.endObject();
    }

    public static boolean isAdmin(User user) {
        if (user == null) {
            return false;
        }
        return user.getRoles().contains("all_access");
    }

    public static void buildStringToObjectMap(XContentBuilder xContentBuilder, Map<?, ?> map) throws IOException {
        xContentBuilder.startObject();
        for (Map.Entry<?, ?> e : map.entrySet()) {
            if (e.getValue() instanceof String) {
                xContentBuilder.field((String)e.getKey(), (String)e.getValue());
                continue;
            }
            xContentBuilder.field((String)e.getKey(), e.getValue());
        }
        xContentBuilder.endObject();
    }

    public static Map<String, String> parseStringToStringMap(XContentParser parser) throws IOException {
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        HashMap<String, String> map = new HashMap<String, String>();
        while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            map.put(fieldName, parser.text());
        }
        return map;
    }

    public static Map<String, Object> parseStringToObjectMap(XContentParser parser) throws IOException {
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        HashMap<String, Object> map = new HashMap<String, Object>();
        while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            if (parser.currentToken() == XContentParser.Token.START_OBJECT) {
                map.put(fieldName, ParseUtils.parseStringToStringMap(parser));
                continue;
            }
            if (parser.currentToken() == XContentParser.Token.START_ARRAY) {
                ArrayList<Object> elements = new ArrayList<Object>();
                while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                    if (parser.currentToken().equals((Object)XContentParser.Token.VALUE_NUMBER)) {
                        elements.add(String.valueOf(parser.numberValue()));
                        continue;
                    }
                    elements.add("\"" + parser.text() + "\"");
                }
                map.put(fieldName, ((Object)elements).toString());
                continue;
            }
            map.put(fieldName, parser.text());
        }
        return map;
    }

    public static Instant parseInstant(XContentParser parser) throws IOException {
        if (parser.currentToken() != null && parser.currentToken().isValue() && parser.currentToken() != XContentParser.Token.VALUE_NULL) {
            return Instant.ofEpochMilli(parser.longValue());
        }
        return null;
    }

    public static User getUserContext(Client client) {
        String userStr = (String)client.threadPool().getThreadContext().getTransient("_opendistro_security_user_info");
        logger.debug("Filtering result by {}", (Object)userStr);
        return User.parse((String)userStr);
    }

    public static SearchSourceBuilder addUserBackendRolesFilter(User user, SearchSourceBuilder searchSourceBuilder) {
        if (user == null) {
            return searchSourceBuilder;
        }
        BoolQueryBuilder boolQueryBuilder = new BoolQueryBuilder();
        String userFieldName = "user";
        String userBackendRoleFieldName = "user.backend_roles.keyword";
        Object backendRoles = user.getBackendRoles() != null ? user.getBackendRoles() : ImmutableList.of();
        TermsQueryBuilder userRolesFilterQuery = QueryBuilders.termsQuery((String)userBackendRoleFieldName, (Collection)backendRoles);
        NestedQueryBuilder nestedQueryBuilder = new NestedQueryBuilder(userFieldName, (QueryBuilder)userRolesFilterQuery, ScoreMode.None);
        boolQueryBuilder.must((QueryBuilder)nestedQueryBuilder);
        QueryBuilder query = searchSourceBuilder.query();
        if (query == null) {
            searchSourceBuilder.query((QueryBuilder)boolQueryBuilder);
        } else if (query instanceof BoolQueryBuilder) {
            ((BoolQueryBuilder)query).filter((QueryBuilder)boolQueryBuilder);
        } else {
            BoolQueryBuilder boolQuery = QueryBuilders.boolQuery().must(query);
            boolQuery.filter((QueryBuilder)boolQueryBuilder);
            searchSourceBuilder.query((QueryBuilder)boolQuery);
        }
        return searchSourceBuilder;
    }

    public static void resolveUserAndExecute(User requestedUser, String workflowId, String tenantId, Boolean filterByEnabled, Boolean statePresent, boolean isMultitenancyEnabled, ActionListener<? extends ActionResponse> listener, Runnable function, Client client, SdkClient sdkClient, ClusterService clusterService, NamedXContentRegistry xContentRegistry) {
        try {
            if (!(isMultitenancyEnabled || requestedUser != null && filterByEnabled != Boolean.FALSE)) {
                function.run();
            } else {
                ParseUtils.getWorkflow(requestedUser, workflowId, tenantId, filterByEnabled, statePresent, isMultitenancyEnabled, listener, function, client, sdkClient, clusterService, xContentRegistry);
            }
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    private static boolean checkUserPermissions(User requestedUser, User resourceUser, String workflowId) throws Exception {
        if (resourceUser.getBackendRoles() == null || requestedUser.getBackendRoles() == null) {
            return false;
        }
        for (String backendRole : requestedUser.getBackendRoles()) {
            if (!resourceUser.getBackendRoles().contains(backendRole)) continue;
            logger.debug("User: " + requestedUser.getName() + " has backend role: " + backendRole + " permissions to access config: " + workflowId);
            return true;
        }
        return false;
    }

    public static void checkFilterByBackendRoles(User requestedUser) {
        if (requestedUser == null) {
            String errorMessage = "Filter by backend roles is enabled and User is null";
            logger.error(errorMessage);
            throw new FlowFrameworkException(errorMessage, RestStatus.BAD_REQUEST);
        }
        if (requestedUser.getBackendRoles().isEmpty()) {
            String userErrorMessage = "Filter by backend roles is enabled, but User " + requestedUser.getName() + " does not have any backend roles configured";
            logger.error(userErrorMessage);
            throw new FlowFrameworkException(userErrorMessage, RestStatus.FORBIDDEN);
        }
    }

    public static void getWorkflow(User requestUser, String workflowId, String tenantId, Boolean filterByEnabled, Boolean statePresent, boolean isMultitenancyEnabled, ActionListener<? extends ActionResponse> listener, Runnable function, Client client, SdkClient sdkClient, ClusterService clusterService, NamedXContentRegistry xContentRegistry) {
        String index;
        String string = index = statePresent != false ? ".plugins-flow-framework-state" : ".plugins-flow-framework-templates";
        if (FlowFrameworkIndicesHandler.doesIndexExistMultitenant(clusterService, index, isMultitenancyEnabled)) {
            try (ThreadContext.StoredContext context = client.threadPool().getThreadContext().stashContext();){
                GetDataObjectRequest request = ((GetDataObjectRequest.Builder)((GetDataObjectRequest.Builder)((GetDataObjectRequest.Builder)GetDataObjectRequest.builder().index(index)).id(workflowId)).tenantId(tenantId)).build();
                sdkClient.getDataObjectAsync(request).whenComplete((r, throwable) -> {
                    if (throwable == null) {
                        try {
                            GetResponse getResponse = r.parser() == null ? null : GetResponse.fromXContent((XContentParser)r.parser());
                            ParseUtils.onGetWorkflowResponse(getResponse, requestUser, workflowId, tenantId, filterByEnabled, statePresent, isMultitenancyEnabled, listener, function, xContentRegistry, context);
                        }
                        catch (IOException e) {
                            logger.error("Failed to parse workflow getResponse: {}", (Object)workflowId, (Object)e);
                            listener.onFailure((Exception)e);
                        }
                    } else {
                        Exception exception = SdkClientUtils.unwrapAndConvertToException((Throwable)throwable, (Class[])new Class[0]);
                        logger.error("Failed to get workflow: {}", (Object)workflowId, (Object)exception);
                        listener.onFailure(exception);
                    }
                });
            }
        } else {
            String errorMessage = ParameterizedMessageFactory.INSTANCE.newMessage("Failed to retrieve template ({}).", (Object)workflowId).getFormattedMessage();
            logger.error(errorMessage);
            listener.onFailure((Exception)((Object)new FlowFrameworkException(errorMessage, RestStatus.NOT_FOUND)));
        }
    }

    public static void onGetWorkflowResponse(GetResponse response, User requestUser, String workflowId, String tenantId, Boolean filterByEnabled, Boolean statePresent, boolean isMultitenancyEnabled, ActionListener<? extends ActionResponse> listener, Runnable function, NamedXContentRegistry xContentRegistry, ThreadContext.StoredContext context) {
        if (response.isExists()) {
            try (XContentParser parser = RestHandlerUtils.createXContentParserFromRegistry(xContentRegistry, response.getSourceAsBytesRef());){
                User resourceUser;
                context.restore();
                XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
                if (statePresent.booleanValue()) {
                    WorkflowState state = WorkflowState.parse(parser);
                    resourceUser = state.getUser();
                    if (!TenantAwareHelper.validateTenantResource(isMultitenancyEnabled, tenantId, state.getTenantId(), listener)) {
                        return;
                    }
                } else {
                    Template template = Template.parse(parser);
                    resourceUser = template.getUser();
                    if (!TenantAwareHelper.validateTenantResource(isMultitenancyEnabled, tenantId, template.getTenantId(), listener)) {
                        return;
                    }
                }
                if (!filterByEnabled.booleanValue() || ParseUtils.checkUserPermissions(requestUser, resourceUser, workflowId) || ParseUtils.isAdmin(requestUser)) {
                    function.run();
                } else {
                    logger.debug("User: " + requestUser.getName() + " does not have permissions to access workflow: " + workflowId);
                    listener.onFailure((Exception)((Object)new FlowFrameworkException("User does not have permissions to access workflow: " + workflowId, RestStatus.FORBIDDEN)));
                }
            }
            catch (Exception e) {
                logger.error("Failed to parse workflow: {}", (Object)workflowId, (Object)e);
                listener.onFailure(e);
            }
        } else {
            String errorMessage = ParameterizedMessageFactory.INSTANCE.newMessage("Failed to retrieve template ({}) from global context.", (Object)workflowId).getFormattedMessage();
            logger.error(errorMessage);
            listener.onFailure((Exception)((Object)new FlowFrameworkException(errorMessage, RestStatus.NOT_FOUND)));
        }
    }

    public static XContentParser createXContentParserFromRegistry(NamedXContentRegistry xContentRegistry, BytesReference bytesReference) throws IOException {
        return XContentHelper.createParser((NamedXContentRegistry)xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (BytesReference)bytesReference, (MediaType)XContentType.JSON);
    }

    public static Map<String, String> getStringToStringMap(Object map, String fieldName) {
        if (map instanceof Map) {
            return (Map)map;
        }
        throw new IllegalArgumentException("[" + fieldName + "] must be a key-value map.");
    }

    public static Map<String, Object> getInputsFromPreviousSteps(Set<String> requiredInputKeys, Set<String> optionalInputKeys, WorkflowData currentNodeInputs, Map<String, WorkflowData> outputs, Map<String, String> previousNodeInputs, Map<String, String> params) {
        HashSet<String> requiredKeys = new HashSet<String>(requiredInputKeys);
        HashSet<String> keys = new HashSet<String>(requiredInputKeys);
        keys.addAll(optionalInputKeys);
        HashMap<String, Object> inputs = new HashMap<String, Object>();
        for (String key : keys) {
            Optional<Object> matchedValue;
            WorkflowData previousNodeOutput;
            Object value = null;
            Optional<String> previousNodeForKey = previousNodeInputs.entrySet().stream().filter(e -> key.equals(e.getValue())).map(Map.Entry::getKey).findAny();
            if (previousNodeForKey.isPresent() && (previousNodeOutput = outputs.get(previousNodeForKey.get())) != null) {
                value = previousNodeOutput.getContent().get(key);
            }
            if (value == null) {
                value = currentNodeInputs.getParams().get(key);
            }
            if (value == null) {
                value = currentNodeInputs.getContent().get(key);
            }
            if (value == null && (matchedValue = outputs.values().stream().map(WorkflowData::getContent).filter(m -> m.containsKey(key)).map(m -> m.get(key)).findAny()).isPresent()) {
                value = matchedValue.get();
            }
            if (value == null) continue;
            if (value instanceof Map) {
                Map valueMap = (Map)value;
                value = valueMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ParseUtils.conditionallySubstitute(e.getValue(), outputs, params)));
            } else {
                value = value instanceof List ? ((List)value).stream().map(v -> ParseUtils.conditionallySubstitute(v, outputs, params)).collect(Collectors.toList()) : ParseUtils.conditionallySubstitute(value, outputs, params);
            }
            inputs.put(key, value);
            requiredKeys.remove(key);
        }
        if (!requiredKeys.isEmpty()) {
            throw new FlowFrameworkException("Missing required inputs " + String.valueOf(requiredKeys) + " in workflow [" + currentNodeInputs.getWorkflowId() + "] node [" + currentNodeInputs.getNodeId() + "]", RestStatus.BAD_REQUEST);
        }
        return inputs;
    }

    public static Object conditionallySubstitute(Object value, Map<String, WorkflowData> outputs, Map<String, String> params) {
        if (value instanceof String) {
            Matcher m = SUBSTITUTION_PATTERN.matcher((String)value);
            StringBuilder result = new StringBuilder();
            while (m.find() && outputs != null) {
                String replacement = m.group(0);
                if (!outputs.containsKey(m.group(1)) || !outputs.get(m.group(1)).getContent().containsKey(m.group(2))) continue;
                String key = m.group(2);
                if (!(outputs.get(m.group(1)).getContent().get(key) instanceof String)) continue;
                replacement = (String)outputs.get(m.group(1)).getContent().get(key);
                m.appendReplacement(result, Matcher.quoteReplacement(replacement));
            }
            m.appendTail(result);
            value = result.toString();
            if (params != null) {
                for (Map.Entry<String, String> e : params.entrySet()) {
                    String regex = "\\$\\{\\{\\s*" + Pattern.quote(e.getKey()) + "\\s*\\}\\}";
                    String replacement = e.getValue();
                    replacement = replacement.replace("\\", "\\\\").replace("\"", "\\\"").replace("\n", "\\n");
                    replacement = Matcher.quoteReplacement(replacement);
                    value = ((String)value).replaceAll(regex, replacement);
                }
            }
        }
        return value;
    }

    public static String parseArbitraryStringToObjectMapToString(Map<String, Object> map) throws Exception {
        try (Jsonb jsonb = JsonbBuilder.create();){
            String string = jsonb.toJson(map);
            return string;
        }
    }

    public static Map<String, String> parseJsonFileToStringToStringMap(String path) throws Exception {
        String jsonContent = ParseUtils.resourceToString(path);
        try (Jsonb jsonb = JsonbBuilder.create();){
            Map resultMap;
            Map map = resultMap = (Map)jsonb.fromJson(jsonContent, Map.class);
            return map;
        }
    }

    public static String removingBackslashesAndQuotesInArrayInJsonString(String input) {
        Matcher matcher = JSON_ARRAY_DOUBLE_QUOTES_PATTERN.matcher(input);
        StringBuffer result = new StringBuffer();
        while (matcher.find()) {
            String withoutEscapes = matcher.group(1).replaceAll("\\\\\"", "\"");
            matcher.appendReplacement(result, "[" + withoutEscapes + "]");
        }
        matcher.appendTail(result);
        return result.toString();
    }

    public static Map<String, String> convertStringToObjectMapToStringToStringMap(Map<String, Object> stringToObjectMap) throws Exception {
        try (Jsonb jsonb = JsonbBuilder.create();){
            HashMap<String, String> stringToStringMap = new HashMap<String, String>();
            for (Map.Entry<String, Object> entry : stringToObjectMap.entrySet()) {
                Object value = entry.getValue();
                if (value instanceof String) {
                    stringToStringMap.put(entry.getKey(), (String)value);
                    continue;
                }
                stringToStringMap.put(entry.getKey(), jsonb.toJson(value));
            }
            HashMap<String, String> hashMap = stringToStringMap;
            return hashMap;
        }
    }

    public static <T> T parseIfExists(Map<String, Object> inputs, String key, Class<T> type) {
        if (!inputs.containsKey(key)) {
            return null;
        }
        Object value = inputs.get(key);
        if (type == Boolean.class) {
            return type.cast(Booleans.parseBoolean((String)value.toString()));
        }
        if (type == Float.class) {
            return type.cast(Float.valueOf(Float.parseFloat(value.toString())));
        }
        throw new IllegalArgumentException("Unsupported type: " + String.valueOf(type));
    }

    public static boolean userInputsEquals(Map<String, Object> originalInputs, Map<String, Object> updatedInputs) throws Exception {
        String originalInputsJson = ParseUtils.parseArbitraryStringToObjectMapToString(originalInputs);
        String updatedInputsJson = ParseUtils.parseArbitraryStringToObjectMapToString(updatedInputs);
        JsonElement elem1 = JsonParser.parseString((String)originalInputsJson);
        JsonElement elem2 = JsonParser.parseString((String)updatedInputsJson);
        return elem1.equals(elem2);
    }

    public static void flattenSettings(String prefix, Map<String, Object> settings, Map<String, Object> flattenedSettings) {
        for (Map.Entry<String, Object> entry : settings.entrySet()) {
            String key = prefix.isEmpty() ? entry.getKey() : prefix + "." + entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Map) {
                ParseUtils.flattenSettings(key, (Map)value, flattenedSettings);
                continue;
            }
            flattenedSettings.put(key, value.toString());
        }
    }

    public static Map<String, Object> prependIndexToSettings(Map<String, Object> originalSettings) {
        HashMap<String, Object> newSettings = new HashMap<String, Object>();
        originalSettings.entrySet().stream().forEach(x -> {
            if (!((String)x.getKey()).startsWith("index.")) {
                newSettings.put("index." + (String)x.getKey(), x.getValue());
            } else {
                newSettings.put((String)x.getKey(), x.getValue());
            }
        });
        return newSettings;
    }
}

